/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlets.statistics;

import com.google.visualization.datasource.base.TypeMismatchException;
import com.google.visualization.datasource.datatable.ColumnDescription;
import com.google.visualization.datasource.datatable.value.Value;
import com.google.visualization.datasource.datatable.value.ValueType;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.jasig.portal.events.aggr.AggregationInterval;
import org.jasig.portal.events.aggr.BaseAggregationDao;
import org.jasig.portal.events.aggr.BaseAggregationDateTimeComparator;
import org.jasig.portal.events.aggr.groups.AggregatedGroupLookupDao;
import org.jasig.portal.events.aggr.groups.AggregatedGroupMapping;
import org.jasig.portal.events.aggr.portletlayout.PortletLayoutAggregation;
import org.jasig.portal.events.aggr.portletlayout.PortletLayoutAggregationDao;
import org.jasig.portal.events.aggr.portletlayout.PortletLayoutAggregationDiscriminator;
import org.jasig.portal.events.aggr.portletlayout.PortletLayoutAggregationDiscriminatorImpl;
import org.jasig.portal.events.aggr.portletlayout.PortletLayoutAggregationKey;
import org.jasig.portal.events.aggr.portletlayout.PortletLayoutAggregationKeyImpl;
import org.jasig.portal.events.aggr.portlets.AggregatedPortletLookupDao;
import org.jasig.portal.events.aggr.portlets.AggregatedPortletMapping;
import org.jasig.portal.events.aggr.portlets.AggregatedPortletMappingNameComparator;
import org.jasig.portal.portlets.statistics.BasePortletLayoutReportForm;
import org.jasig.portal.portlets.statistics.BaseStatisticsReportController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.portlet.ModelAndView;

public abstract class BasePortletLayoutStatisticsController<F extends BasePortletLayoutReportForm>
extends BaseStatisticsReportController<PortletLayoutAggregation, PortletLayoutAggregationKey, PortletLayoutAggregationDiscriminator, F> {
    @Autowired
    protected PortletLayoutAggregationDao<PortletLayoutAggregation> portletLayoutDao;
    @Autowired
    protected AggregatedGroupLookupDao aggregatedGroupLookupDao;
    @Autowired
    protected AggregatedPortletLookupDao aggregatedPortletLookupDao;

    public String getLoginView() throws TypeMismatchException {
        return "jsp/Statistics/reportGraph";
    }

    public ModelAndView renderPortletAddAggregationReport(F form) throws TypeMismatchException {
        return this.renderAggregationReport(form);
    }

    public abstract String getReportName();

    public abstract String getReportDataResourceId();

    protected void initReportForm(F report) {
        super.initReportForm(report);
        this.selectFormDefaultPortlet(report);
    }

    protected void selectFormDefaultPortlet(F report) {
        Set portlets = this.getPortlets();
        if (!portlets.isEmpty()) {
            report.getPortlets().add(((AggregatedPortletMapping)portlets.iterator().next()).getFname());
        }
    }

    @ModelAttribute(value="portlets")
    public Set<AggregatedPortletMapping> getPortlets() {
        Set groupMappings = this.aggregatedPortletLookupDao.getPortletMappings();
        TreeSet<AggregatedPortletMapping> sortedGroupMappings = new TreeSet<AggregatedPortletMapping>(AggregatedPortletMappingNameComparator.INSTANCE);
        sortedGroupMappings.addAll(groupMappings);
        return sortedGroupMappings;
    }

    protected BaseAggregationDao<PortletLayoutAggregation, PortletLayoutAggregationKey> getBaseAggregationDao() {
        return this.portletLayoutDao;
    }

    protected Set<PortletLayoutAggregationKey> createAggregationsQueryKeyset(Set<PortletLayoutAggregationDiscriminator> columnDiscriminators, F form) {
        AggregationInterval interval = form.getInterval();
        HashSet<PortletLayoutAggregationKey> keys = new HashSet<PortletLayoutAggregationKey>();
        for (PortletLayoutAggregationDiscriminator discriminator : columnDiscriminators) {
            keys.add((PortletLayoutAggregationKey)new PortletLayoutAggregationKeyImpl(interval, discriminator.getAggregatedGroup(), discriminator.getPortletMapping()));
        }
        return keys;
    }

    protected Comparator<? super PortletLayoutAggregationDiscriminator> getDiscriminatorComparator() {
        return PortletLayoutAggregationDiscriminatorImpl.Comparator.INSTANCE;
    }

    protected Map<PortletLayoutAggregationDiscriminator, SortedSet<PortletLayoutAggregation>> createColumnDiscriminatorMap(F form) {
        TreeMap<PortletLayoutAggregationDiscriminator, SortedSet<PortletLayoutAggregation>> groupedAggregations = new TreeMap<PortletLayoutAggregationDiscriminator, SortedSet<PortletLayoutAggregation>>((Comparator<PortletLayoutAggregationDiscriminator>)PortletLayoutAggregationDiscriminatorImpl.Comparator.INSTANCE);
        List groups = form.getGroups();
        Set portletFNames = form.getPortlets();
        for (Long queryGroupId : groups) {
            AggregatedGroupMapping groupMapping = this.aggregatedGroupLookupDao.getGroupMapping(queryGroupId.longValue());
            for (String portletFName : portletFNames) {
                AggregatedPortletMapping tabMapping = this.aggregatedPortletLookupDao.getMappedPortletForFname(portletFName);
                PortletLayoutAggregationDiscriminatorImpl mapping = new PortletLayoutAggregationDiscriminatorImpl(groupMapping, tabMapping);
                TreeSet aggregations = new TreeSet(BaseAggregationDateTimeComparator.INSTANCE);
                groupedAggregations.put((PortletLayoutAggregationDiscriminator)mapping, aggregations);
            }
        }
        return groupedAggregations;
    }

    protected String getReportTitleAugmentation(F form) {
        int groupSize = form.getGroups().size();
        int portletSize = form.getPortlets().size();
        if (portletSize > 1 && groupSize > 1) {
            return null;
        }
        String firstPortletName = this.aggregatedPortletLookupDao.getMappedPortletForFname((String)form.getPortlets().iterator().next()).getFname();
        Long firstGroupId = (long)((Long)form.getGroups().iterator().next());
        String firstGroupName = this.aggregatedGroupLookupDao.getGroupMapping(firstGroupId.longValue()).getGroupName();
        String augmentedTitle = groupSize == 1 && portletSize > 1 ? firstGroupName : firstPortletName;
        return augmentedTitle;
    }

    protected List<ColumnDescription> getColumnDescriptions(PortletLayoutAggregationDiscriminator reportColumnDiscriminator, F form) {
        int groupSize = form.getGroups().size();
        int portletSize = form.getPortlets().size();
        String portletName = reportColumnDiscriminator.getPortletMapping().getFname();
        String groupName = reportColumnDiscriminator.getAggregatedGroup().getGroupName();
        String description = null;
        description = this.showFullColumnHeaderDescriptions(form) || groupSize > 1 && portletSize > 1 ? String.format("%s - %s", portletName, groupName) : (groupSize == 1 && portletSize > 1 ? portletName : groupName);
        ArrayList<ColumnDescription> columnDescriptions = new ArrayList<ColumnDescription>();
        columnDescriptions.add(new ColumnDescription(description, ValueType.NUMBER, description));
        return columnDescriptions;
    }

    protected abstract List<Value> createRowValues(PortletLayoutAggregation var1, F var2);
}

