/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlets.statistics;

import com.google.visualization.datasource.base.TypeMismatchException;
import com.google.visualization.datasource.datatable.ColumnDescription;
import com.google.visualization.datasource.datatable.value.NumberValue;
import com.google.visualization.datasource.datatable.value.Value;
import com.google.visualization.datasource.datatable.value.ValueType;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import org.jasig.portal.events.aggr.AggregationInterval;
import org.jasig.portal.events.aggr.BaseAggregationDao;
import org.jasig.portal.events.aggr.concuser.ConcurrentUserAggregation;
import org.jasig.portal.events.aggr.concuser.ConcurrentUserAggregationDao;
import org.jasig.portal.events.aggr.concuser.ConcurrentUserAggregationDiscriminator;
import org.jasig.portal.events.aggr.concuser.ConcurrentUserAggregationDiscriminatorImpl;
import org.jasig.portal.events.aggr.concuser.ConcurrentUserAggregationKey;
import org.jasig.portal.events.aggr.concuser.ConcurrentUserAggregationKeyImpl;
import org.jasig.portal.events.aggr.groups.AggregatedGroupLookupDao;
import org.jasig.portal.events.aggr.groups.AggregatedGroupMapping;
import org.jasig.portal.portlets.statistics.BaseReportForm;
import org.jasig.portal.portlets.statistics.BaseSimpleGroupedStatisticsReportController;
import org.jasig.portal.portlets.statistics.ConcurrentUserReportForm;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.portlet.ModelAndView;
import org.springframework.web.portlet.bind.annotation.RenderMapping;
import org.springframework.web.portlet.bind.annotation.ResourceMapping;

@Controller
@RequestMapping(value={"VIEW"})
public class ConcurrentUsersStatisticsController
extends BaseSimpleGroupedStatisticsReportController<ConcurrentUserAggregation, ConcurrentUserAggregationKey, ConcurrentUserAggregationDiscriminator, ConcurrentUserReportForm> {
    private static final String DATA_TABLE_RESOURCE_ID = "concurrentUserData";
    private static final String REPORT_NAME = "concurrent.users";
    @Autowired
    private ConcurrentUserAggregationDao<ConcurrentUserAggregation> concurrentUserAggregationDao;
    @Autowired
    private AggregatedGroupLookupDao aggregatedGroupDao;

    @RenderMapping(value="MAXIMIZED", params={"report=concurrent.users"})
    public String getConcurrentUserView() throws TypeMismatchException {
        return "jsp/Statistics/reportGraph";
    }

    @ResourceMapping(value="concurrentUserData")
    public ModelAndView renderConcurrentUserAggregationReport(ConcurrentUserReportForm form) throws TypeMismatchException {
        return this.renderAggregationReport((BaseReportForm)form);
    }

    public String getReportName() {
        return REPORT_NAME;
    }

    public String getReportDataResourceId() {
        return DATA_TABLE_RESOURCE_ID;
    }

    protected BaseAggregationDao<ConcurrentUserAggregation, ConcurrentUserAggregationKey> getBaseAggregationDao() {
        return this.concurrentUserAggregationDao;
    }

    protected Comparator<? super ConcurrentUserAggregationDiscriminator> getDiscriminatorComparator() {
        return ConcurrentUserAggregationDiscriminatorImpl.Comparator.INSTANCE;
    }

    protected Map<ConcurrentUserAggregationDiscriminator, SortedSet<ConcurrentUserAggregation>> createColumnDiscriminatorMap(ConcurrentUserReportForm form) {
        return this.getDefaultGroupedColumnDiscriminatorMap((BaseReportForm)form);
    }

    protected Set<ConcurrentUserAggregationKey> createAggregationsQueryKeyset(Set<ConcurrentUserAggregationDiscriminator> groups, ConcurrentUserReportForm form) {
        AggregationInterval interval = form.getInterval();
        HashSet<ConcurrentUserAggregationKey> keys = new HashSet<ConcurrentUserAggregationKey>();
        keys.add((ConcurrentUserAggregationKey)new ConcurrentUserAggregationKeyImpl(interval, groups.iterator().next().getAggregatedGroup()));
        return keys;
    }

    protected List<ColumnDescription> getColumnDescriptions(ConcurrentUserAggregationDiscriminator discriminator, ConcurrentUserReportForm form) {
        String groupName = discriminator.getAggregatedGroup().getGroupName();
        return Collections.singletonList(new ColumnDescription(groupName, ValueType.NUMBER, groupName));
    }

    protected List<Value> createRowValues(ConcurrentUserAggregation aggr, ConcurrentUserReportForm form) {
        int concurrentUsers = aggr == null ? 0 : aggr.getConcurrentUsers();
        return Collections.singletonList(new NumberValue((double)concurrentUsers));
    }

    protected ConcurrentUserAggregationDiscriminator createGroupedDiscriminatorInstance(AggregatedGroupMapping groupMapping) {
        return new ConcurrentUserAggregationDiscriminatorImpl(groupMapping);
    }
}

