/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlets.statistics;

import com.google.common.collect.ImmutableList;
import com.google.visualization.datasource.base.TypeMismatchException;
import com.google.visualization.datasource.datatable.ColumnDescription;
import com.google.visualization.datasource.datatable.value.NumberValue;
import com.google.visualization.datasource.datatable.value.Value;
import com.google.visualization.datasource.datatable.value.ValueType;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import org.jasig.portal.events.aggr.AggregationInterval;
import org.jasig.portal.events.aggr.BaseAggregationDao;
import org.jasig.portal.events.aggr.groups.AggregatedGroupLookupDao;
import org.jasig.portal.events.aggr.groups.AggregatedGroupMapping;
import org.jasig.portal.events.aggr.login.LoginAggregation;
import org.jasig.portal.events.aggr.login.LoginAggregationDao;
import org.jasig.portal.events.aggr.login.LoginAggregationDiscriminator;
import org.jasig.portal.events.aggr.login.LoginAggregationDiscriminatorImpl;
import org.jasig.portal.events.aggr.login.LoginAggregationKey;
import org.jasig.portal.events.aggr.login.LoginAggregationKeyImpl;
import org.jasig.portal.portlets.statistics.BaseReportForm;
import org.jasig.portal.portlets.statistics.BaseSimpleGroupedStatisticsReportController;
import org.jasig.portal.portlets.statistics.LoginReportForm;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.portlet.ModelAndView;
import org.springframework.web.portlet.bind.annotation.RenderMapping;
import org.springframework.web.portlet.bind.annotation.ResourceMapping;

@Controller
@RequestMapping(value={"VIEW"})
public class LoginTotalsStatisticsController
extends BaseSimpleGroupedStatisticsReportController<LoginAggregation, LoginAggregationKey, LoginAggregationDiscriminator, LoginReportForm> {
    private static final String DATA_TABLE_RESOURCE_ID = "loginData";
    private static final String REPORT_NAME = "login.totals";
    @Autowired
    private LoginAggregationDao<LoginAggregation> loginDao;
    @Autowired
    private AggregatedGroupLookupDao aggregatedGroupDao;

    @RenderMapping(value="MAXIMIZED", params={"report=login.totals"})
    public String getLoginView() throws TypeMismatchException {
        return "jsp/Statistics/reportGraph";
    }

    @ResourceMapping(value="loginData")
    public ModelAndView renderLoginAggregationReport(LoginReportForm form) throws TypeMismatchException {
        return this.renderAggregationReport((BaseReportForm)form);
    }

    public String getReportName() {
        return REPORT_NAME;
    }

    public String getReportDataResourceId() {
        return DATA_TABLE_RESOURCE_ID;
    }

    protected BaseAggregationDao<LoginAggregation, LoginAggregationKey> getBaseAggregationDao() {
        return this.loginDao;
    }

    protected Set<LoginAggregationKey> createAggregationsQueryKeyset(Set<LoginAggregationDiscriminator> discriminators, LoginReportForm form) {
        AggregatedGroupMapping groupToUse = discriminators.iterator().next().getAggregatedGroup();
        AggregationInterval interval = form.getInterval();
        HashSet<LoginAggregationKey> keys = new HashSet<LoginAggregationKey>();
        keys.add((LoginAggregationKey)new LoginAggregationKeyImpl(interval, groupToUse));
        return keys;
    }

    protected Comparator<? super LoginAggregationDiscriminator> getDiscriminatorComparator() {
        return LoginAggregationDiscriminatorImpl.Comparator.INSTANCE;
    }

    protected Map<LoginAggregationDiscriminator, SortedSet<LoginAggregation>> createColumnDiscriminatorMap(LoginReportForm form) {
        return this.getDefaultGroupedColumnDiscriminatorMap((BaseReportForm)form);
    }

    protected List<ColumnDescription> getColumnDescriptions(LoginAggregationDiscriminator columnDiscriminator, LoginReportForm form) {
        String groupName = columnDiscriminator.getAggregatedGroup().getGroupName();
        if (form.isTotalLogins() && form.isUniqueLogins()) {
            return ImmutableList.of((Object)new ColumnDescription(groupName + "-uniqueLogins", ValueType.NUMBER, groupName + " - Unique Logins"), (Object)new ColumnDescription(groupName + "-totalLogins", ValueType.NUMBER, groupName + " - Total Logins"));
        }
        if (form.isUniqueLogins()) {
            return Collections.singletonList(new ColumnDescription(groupName + "-uniqueLogins", ValueType.NUMBER, groupName + " - Unique Logins"));
        }
        return Collections.singletonList(new ColumnDescription(groupName + "-totalLogins", ValueType.NUMBER, groupName + " - Total Logins"));
    }

    protected List<Value> createRowValues(LoginAggregation aggr, LoginReportForm form) {
        int uniqueLoginCount;
        int loginCount;
        if (aggr == null) {
            loginCount = 0;
            uniqueLoginCount = 0;
        } else {
            loginCount = aggr.getLoginCount();
            uniqueLoginCount = aggr.getUniqueLoginCount();
        }
        if (form.isTotalLogins() && form.isUniqueLogins()) {
            return ImmutableList.of((Object)new NumberValue((double)uniqueLoginCount), (Object)new NumberValue((double)loginCount));
        }
        if (form.isUniqueLogins()) {
            return Collections.singletonList(new NumberValue((double)uniqueLoginCount));
        }
        return Collections.singletonList(new NumberValue((double)loginCount));
    }

    protected LoginAggregationDiscriminator createGroupedDiscriminatorInstance(AggregatedGroupMapping groupMapping) {
        return new LoginAggregationDiscriminatorImpl(groupMapping);
    }
}

