/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlets.statistics;

import com.google.visualization.datasource.base.TypeMismatchException;
import java.beans.PropertyEditor;
import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import org.jasig.portal.events.aggr.AggregationInterval;
import org.jasig.portal.events.aggr.AggregationIntervalHelper;
import org.jasig.portal.portlets.statistics.BaseStatisticsReportController;
import org.jasig.portal.portlets.statistics.CustomDateMidnightEditor;
import org.joda.time.DateMidnight;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.portlet.ModelAndView;
import org.springframework.web.portlet.bind.annotation.RenderMapping;
import org.springframework.web.portlet.bind.annotation.ResourceMapping;

@Controller
@RequestMapping(value={"VIEW"})
public class StatisticsPortletController {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Set<String> statisticsReportControllerNames;
    @Autowired
    private AggregationIntervalHelper intervalHelper;
    @Value(value="${org.jasig.portal.portlets.statistics.maxIntervals}")
    private int maxIntervals = 4000;

    @Autowired
    public void setStatisticsReportControllers(Collection<BaseStatisticsReportController<?, ?, ?, ?>> statisticsReportControllers) {
        this.statisticsReportControllerNames = new TreeSet();
        for (BaseStatisticsReportController<?, ?, ?, ?> controller : statisticsReportControllers) {
            this.statisticsReportControllerNames.add(controller.getReportName());
        }
    }

    @InitBinder
    public void initBinder(WebDataBinder binder) {
        DateTimeFormatter formatter = new DateTimeFormatterBuilder().appendPattern("M/d/yyyy").toFormatter();
        binder.registerCustomEditor(DateMidnight.class, (PropertyEditor)new CustomDateMidnightEditor(formatter, false));
    }

    @RenderMapping
    public String getReportList() throws TypeMismatchException {
        return "jsp/Statistics/reportList";
    }

    @ModelAttribute(value="reports")
    public Set<String> getIntervals() {
        return this.statisticsReportControllerNames;
    }

    @ModelAttribute(value="maxIntervals")
    public Integer getMaxIntervals() {
        return this.maxIntervals;
    }

    @ResourceMapping(value="intervalCount")
    public ModelAndView getIntervalCount(@RequestParam(value="interval") AggregationInterval interval, @RequestParam(value="start") DateMidnight start, @RequestParam(value="end") DateMidnight end) throws TypeMismatchException {
        int intervalsBetween = this.intervalHelper.intervalsBetween(interval, start.toDateTime(), end.plusDays(1).toDateTime().minusSeconds(1));
        return new ModelAndView("json", "intervalsBetween", (Object)intervalsBetween);
    }
}

