/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlets.translator;

import java.util.ArrayList;
import java.util.Locale;
import java.util.Set;
import org.jasig.portal.i18n.LocaleManager;
import org.jasig.portal.i18n.Message;
import org.jasig.portal.i18n.dao.IMessageDao;
import org.jasig.portal.portlets.translator.TranslatableEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.portlet.ModelAndView;
import org.springframework.web.portlet.bind.annotation.ResourceMapping;

@Controller
@RequestMapping(value={"VIEW"}, params={"entity=message"})
public class MessageEntityTranslationController {
    private IMessageDao messageDao;

    @Autowired
    public void setMessageDao(IMessageDao messageDao) {
        this.messageDao = messageDao;
    }

    @ResourceMapping
    @RequestMapping(params={"action=getEntityList"})
    public ModelAndView getEntityList() throws Exception {
        Set codes = this.messageDao.getCodes();
        ArrayList<TranslatableEntity> entities = new ArrayList<TranslatableEntity>();
        for (String code : codes) {
            TranslatableEntity entity = new TranslatableEntity();
            entity.setId(code);
            entity.setTitle(code);
            entities.add(entity);
        }
        return new ModelAndView("json", "entities", entities);
    }

    @ResourceMapping
    @RequestMapping(params={"action=getEntity"})
    public ModelAndView getEntity(@RequestParam(value="id") String code, @RequestParam(value="locale") String localeStr) {
        Locale locale = LocaleManager.parseLocale((String)localeStr);
        Message message = this.messageDao.getMessage(code, locale);
        return new ModelAndView("json", "message", (Object)message);
    }

    @ResourceMapping
    @RequestMapping(params={"action=postTranslation"})
    public ModelAndView postTranslation(@RequestParam(value="id") String code, @RequestParam(value="locale") String localeStr, @RequestParam(value="value") String value) {
        Locale locale = LocaleManager.parseLocale((String)localeStr);
        if (locale != null && StringUtils.hasText((String)code) && StringUtils.hasText((String)value)) {
            Message message = this.messageDao.getMessage(code, locale);
            if (message != null) {
                message.setValue(value);
                this.messageDao.updateMessage(message);
            } else {
                this.messageDao.createMessage(code, locale, value);
            }
        }
        return new ModelAndView("json");
    }
}

