/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlets.translator;

import java.util.ArrayList;
import java.util.List;
import javax.portlet.ResourceRequest;
import org.jasig.portal.portlet.dao.IPortletDefinitionDao;
import org.jasig.portal.portlet.om.IPortletDefinition;
import org.jasig.portal.portlets.translator.LocalizedPortletDefinition;
import org.jasig.portal.portlets.translator.PortletDefinitionTranslation;
import org.jasig.portal.portlets.translator.TranslatableEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.portlet.ModelAndView;
import org.springframework.web.portlet.bind.annotation.ResourceMapping;

@Controller
@RequestMapping(value={"VIEW"}, params={"entity=portlet"})
public class PortletEntityTranslationController {
    public static final String ENTITY_TYPE_PORTLET = "protlet";
    private IPortletDefinitionDao portletDefinitionDao;

    @Autowired(required=true)
    public void setPortletDefinitionDao(IPortletDefinitionDao portletDefinitionDao) {
        this.portletDefinitionDao = portletDefinitionDao;
    }

    @ResourceMapping
    @RequestMapping(params={"action=getEntityList"})
    public ModelAndView getEntityList() throws Exception {
        List portletDefs = this.portletDefinitionDao.getPortletDefinitions();
        ArrayList<TranslatableEntity> entities = new ArrayList<TranslatableEntity>();
        for (IPortletDefinition portletDef : portletDefs) {
            TranslatableEntity entity = new TranslatableEntity();
            entity.setId(portletDef.getPortletDefinitionId().getStringId());
            entity.setTitle(portletDef.getTitle());
            entities.add(entity);
        }
        return new ModelAndView("json", "entities", entities);
    }

    @ResourceMapping
    @RequestMapping(params={"action=getEntity"})
    public ModelAndView getPortletDefinition(@RequestParam(value="id") String portletId, @RequestParam(value="locale") String locale) throws Exception {
        IPortletDefinition definition = this.portletDefinitionDao.getPortletDefinition(portletId);
        PortletDefinitionTranslation translation = new PortletDefinitionTranslation();
        translation.setId(portletId);
        translation.setLocale(locale);
        translation.setLocalized(new LocalizedPortletDefinition(definition, locale));
        translation.setOriginal(new LocalizedPortletDefinition(definition, null));
        return new ModelAndView("json", "portlet", (Object)translation);
    }

    @ResourceMapping
    @RequestMapping(params={"action=postTranslation"})
    public ModelAndView postPortletTranslation(@RequestParam(value="id") String portletId, @RequestParam(value="locale") String locale, ResourceRequest request) throws Exception {
        IPortletDefinition definition = this.portletDefinitionDao.getPortletDefinition(portletId);
        if (definition != null) {
            definition.addLocalizedTitle(locale, request.getParameter("title"));
            definition.addLocalizedName(locale, request.getParameter("name"));
            definition.addLocalizedDescription(locale, request.getParameter("description"));
            this.portletDefinitionDao.updatePortletDefinition(definition);
        }
        return new ModelAndView("json");
    }
}

