/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.redirect;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.annotation.Resource;
import javax.portlet.WindowState;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.portlet.om.IPortletWindow;
import org.jasig.portal.portlet.registry.IPortletWindowRegistry;
import org.jasig.portal.redirect.ExternalRedirectionUrl;
import org.jasig.portal.redirect.IRedirectionUrl;
import org.jasig.portal.redirect.PortletRedirectionUrl;
import org.jasig.portal.url.IPortalUrlBuilder;
import org.jasig.portal.url.IPortalUrlProvider;
import org.jasig.portal.url.IPortletUrlBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.HandlerMapping;

@Controller
public class PortletRedirectionController {
    protected final Log log = LogFactory.getLog(this.getClass());
    private IPortalUrlProvider portalUrlProvider;
    private IPortletWindowRegistry portletWindowRegistry;
    private Map<String, IRedirectionUrl> services;

    @Autowired
    public void setPortalUrlProvider(IPortalUrlProvider urlProvider) {
        this.portalUrlProvider = urlProvider;
    }

    @Autowired
    public void setPortletWindowRegistry(IPortletWindowRegistry portletWindowRegistry) {
        this.portletWindowRegistry = portletWindowRegistry;
    }

    @Required
    @Resource(name="redirectionServices")
    public void setServices(Map<String, IRedirectionUrl> services) {
        this.services = services;
    }

    @RequestMapping(value={"{serviceKey}/*/**", "{serviceKey}"})
    public void redirectExtra(HttpServletRequest request, HttpServletResponse response, @PathVariable String serviceKey) throws IOException {
        String path = (String)request.getAttribute(HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE);
        List<String> pathElements = Arrays.asList(path.split("/"));
        IRedirectionUrl url = (IRedirectionUrl)this.services.get(serviceKey);
        if (url == null) {
            response.sendError(404);
        }
        String redirectUrl = this.getUrlString(url, request, pathElements);
        response.sendRedirect(redirectUrl);
    }

    protected String getUrlString(IRedirectionUrl url, HttpServletRequest request, List<String> extraPath) {
        if (url instanceof ExternalRedirectionUrl) {
            ExternalRedirectionUrl externalUrl = (ExternalRedirectionUrl)url;
            StringBuffer urlStr = new StringBuffer();
            urlStr.append(externalUrl.getUrl());
            try {
                String separator = "?";
                for (Map.Entry param : externalUrl.getAdditionalParameters().entrySet()) {
                    for (String value : (String[])param.getValue()) {
                        urlStr.append(separator);
                        urlStr.append((String)param.getKey());
                        urlStr.append("=");
                        urlStr.append(URLEncoder.encode(value, "UTF-8"));
                        separator = "&";
                    }
                }
                for (Map.Entry param : externalUrl.getDynamicParameters().entrySet()) {
                    String[] values = request.getParameterValues((String)param.getKey());
                    if (values == null) continue;
                    for (String value : values) {
                        urlStr.append(separator);
                        urlStr.append((String)param.getValue());
                        urlStr.append("=");
                        urlStr.append(URLEncoder.encode(value, "UTF-8"));
                        separator = "&";
                    }
                }
                if (!extraPath.isEmpty()) {
                    List paramNames = externalUrl.getPathParameters();
                    ListIterator itt = paramNames.listIterator();
                    while (itt.hasNext() && !extraPath.isEmpty()) {
                        int index = itt.nextIndex();
                        String param = (String)itt.next();
                        String value = itt.hasNext() ? extraPath.remove(0) : StringUtils.join(extraPath, (String)"/");
                        urlStr.append(separator);
                        urlStr.append(param);
                        urlStr.append("=");
                        urlStr.append(URLEncoder.encode(value, "UTF-8"));
                        separator = "&";
                    }
                }
                return urlStr.toString();
            }
            catch (UnsupportedEncodingException ex) {
                this.log.error((Object)"Unable to encode URL parameter for external service redirect", (Throwable)ex);
                return null;
            }
        }
        PortletRedirectionUrl portletUrl = (PortletRedirectionUrl)url;
        IPortletWindow portletWindow = this.portletWindowRegistry.getOrCreateDefaultPortletWindowByFname(request, portletUrl.getFname());
        IPortalUrlBuilder portalUrlBuilder = this.portalUrlProvider.getPortalUrlBuilderByPortletWindow(request, portletWindow.getPortletWindowId(), portletUrl.getType());
        IPortletUrlBuilder portletUrlBuilder = portalUrlBuilder.getTargetedPortletUrlBuilder();
        portletUrlBuilder.setPortletMode(portletUrl.getMode());
        portletUrlBuilder.setWindowState(WindowState.MAXIMIZED);
        for (Map.Entry param : portletUrl.getAdditionalParameters().entrySet()) {
            portletUrlBuilder.addParameter((String)param.getKey(), (String[])param.getValue());
        }
        for (Map.Entry param : portletUrl.getDynamicParameters().entrySet()) {
            String[] values = request.getParameterValues((String)param.getKey());
            if (values == null) continue;
            portletUrlBuilder.addParameter((String)param.getValue(), values);
        }
        if (!extraPath.isEmpty()) {
            List paramNames = portletUrl.getPathParameters();
            ListIterator itt = paramNames.listIterator();
            while (itt.hasNext() && !extraPath.isEmpty()) {
                String param = (String)itt.next();
                String value = itt.hasNext() ? extraPath.remove(0) : StringUtils.join(extraPath, (String)"/");
                if (StringUtils.isEmpty((String)value)) break;
                portletUrlBuilder.addParameter(param, new String[]{value});
            }
        }
        return portalUrlBuilder.getUrlString();
    }
}

