/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.rendering;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jasig.portal.portlet.om.IPortletWindowId;
import org.jasig.portal.portlet.rendering.IPortletExecutionManager;
import org.jasig.portal.rendering.IPortalRenderingPipeline;
import org.jasig.portal.url.IPortalRequestInfo;
import org.jasig.portal.url.IPortalUrlBuilder;
import org.jasig.portal.url.IPortalUrlProvider;
import org.jasig.portal.url.IPortletRequestInfo;
import org.jasig.portal.url.IUrlSyntaxProvider;
import org.jasig.portal.url.UrlType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/**"})
public class PortalController {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private IPortalRenderingPipeline portalRenderingPipeline;
    private IPortletExecutionManager portletExecutionManager;
    private IPortalUrlProvider portalUrlProvider;
    private IUrlSyntaxProvider urlSyntaxProvider;

    @Autowired
    @Qualifier(value="main")
    public void setPortalRenderingPipeline(IPortalRenderingPipeline portalRenderingPipeline) {
        this.portalRenderingPipeline = portalRenderingPipeline;
    }

    @Autowired
    public void setPortletExecutionManager(IPortletExecutionManager portletExecutionManager) {
        this.portletExecutionManager = portletExecutionManager;
    }

    @Autowired
    public void setPortalUrlProvider(IPortalUrlProvider portalUrlProvider) {
        this.portalUrlProvider = portalUrlProvider;
    }

    @Autowired
    public void setUrlSyntaxProvider(IUrlSyntaxProvider urlSyntaxProvider) {
        this.urlSyntaxProvider = urlSyntaxProvider;
    }

    @RequestMapping(headers={"org.jasig.portal.url.UrlType=RENDER", "org.jasig.portal.url.UrlState.EXCLUSIVE=true"})
    public void renderExclusive(HttpServletRequest request, HttpServletResponse response) {
        IPortalRequestInfo portalRequestInfo = this.urlSyntaxProvider.getPortalRequestInfo(request);
        IPortletRequestInfo portletRequestInfo = portalRequestInfo.getTargetedPortletRequestInfo();
        if (portletRequestInfo == null) {
            throw new IllegalArgumentException("A portlet must be targeted when using the EXCLUSIVE WindowState: " + portalRequestInfo);
        }
        IPortletWindowId portletWindowId = portletRequestInfo.getPortletWindowId();
        this.portletExecutionManager.getPortletOutput(portletWindowId, request, response);
    }

    @RequestMapping(headers={"org.jasig.portal.url.UrlType=RENDER"})
    public void renderRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.portalRenderingPipeline.renderState(request, response);
    }

    @RequestMapping(headers={"org.jasig.portal.url.UrlType=ACTION"})
    public void actionRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        IPortalUrlBuilder actionRedirectUrl;
        IPortletWindowId targetWindowId;
        IPortalRequestInfo portalRequestInfo = this.urlSyntaxProvider.getPortalRequestInfo(request);
        IPortletRequestInfo portletRequestInfo = portalRequestInfo.getTargetedPortletRequestInfo();
        if (portletRequestInfo != null) {
            targetWindowId = portletRequestInfo.getPortletWindowId();
            actionRedirectUrl = this.portalUrlProvider.getPortalUrlBuilderByPortletWindow(request, targetWindowId, UrlType.RENDER);
        } else {
            String targetedLayoutNodeId = portalRequestInfo.getTargetedLayoutNodeId();
            actionRedirectUrl = targetedLayoutNodeId != null ? this.portalUrlProvider.getPortalUrlBuilderByLayoutNode(request, targetedLayoutNodeId, UrlType.RENDER) : this.portalUrlProvider.getDefaultUrl(request);
        }
        this.portalUrlProvider.convertToPortalActionUrlBuilder(request, actionRedirectUrl);
        if (portletRequestInfo != null) {
            targetWindowId = portletRequestInfo.getPortletWindowId();
            try {
                this.portletExecutionManager.doPortletAction(targetWindowId, request, response);
            }
            catch (RuntimeException e) {
                this.logger.error("Exception thrown while executing portlet action for: " + portletRequestInfo, (Throwable)e);
                actionRedirectUrl.setParameter("portletActionError", new String[]{targetWindowId.toString()});
            }
        }
        this.sendRedirect(actionRedirectUrl, response);
    }

    @RequestMapping(headers={"org.jasig.portal.url.UrlType=RESOURCE"})
    public void resourceRequest(HttpServletRequest request, HttpServletResponse response) {
        IPortalRequestInfo portalRequestInfo = this.urlSyntaxProvider.getPortalRequestInfo(request);
        IPortletRequestInfo portletRequestInfo = portalRequestInfo.getTargetedPortletRequestInfo();
        if (portletRequestInfo != null) {
            IPortletWindowId targetWindowId = portletRequestInfo.getPortletWindowId();
            this.portletExecutionManager.doPortletServeResource(targetWindowId, request, response);
        } else {
            this.logger.error("portletRequestInfo was null for resourceRequest");
        }
    }

    private void sendRedirect(IPortalUrlBuilder portalUurl, HttpServletResponse response) throws IOException {
        String url = portalUurl.getUrlString();
        String encodedUrl = response.encodeRedirectURL(url);
        response.sendRedirect(encodedUrl);
    }
}

