/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.rendering;

import java.io.StringWriter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import org.jasig.portal.character.stream.CharacterEventBufferReader;
import org.jasig.portal.character.stream.CharacterEventReader;
import org.jasig.portal.character.stream.CharacterEventSource;
import org.jasig.portal.character.stream.events.CharacterEvent;
import org.jasig.portal.rendering.CharacterPipelineComponent;
import org.jasig.portal.rendering.PipelineEventReader;
import org.jasig.portal.rendering.PipelineEventReaderImpl;
import org.jasig.portal.rendering.StAXPipelineComponent;
import org.jasig.portal.utils.cache.CacheKey;
import org.jasig.portal.xml.XmlUtilities;
import org.jasig.portal.xml.stream.ChunkingEventReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class StAXSerializingComponent
implements CharacterPipelineComponent {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private XmlUtilities xmlUtilities;
    private StAXPipelineComponent wrappedComponent;
    private Map<String, CharacterEventSource> chunkingElements;
    private Map<Pattern, CharacterEventSource> chunkingPatternEventSources;
    private Pattern[] chunkingPatterns;

    @Autowired
    public void setXmlUtilities(XmlUtilities xmlUtilities) {
        this.xmlUtilities = xmlUtilities;
    }

    public void setWrappedComponent(StAXPipelineComponent wrappedComponent) {
        this.wrappedComponent = wrappedComponent;
    }

    public void setChunkingElements(Map<String, CharacterEventSource> chunkingElements) {
        this.chunkingElements = chunkingElements;
    }

    public void setChunkingPatterns(Map<String, CharacterEventSource> chunkingPatterns) {
        LinkedHashMap<Pattern, CharacterEventSource> compiledChunkingPatternEventSources = new LinkedHashMap<Pattern, CharacterEventSource>();
        for (Map.Entry<String, CharacterEventSource> chunkingPatternEntry : chunkingPatterns.entrySet()) {
            String key = chunkingPatternEntry.getKey();
            Pattern pattern = Pattern.compile(key);
            CharacterEventSource value = chunkingPatternEntry.getValue();
            compiledChunkingPatternEventSources.put(pattern, value);
        }
        this.chunkingPatternEventSources = compiledChunkingPatternEventSources;
        this.chunkingPatterns = this.chunkingPatternEventSources.keySet().toArray(new Pattern[this.chunkingPatternEventSources.size()]);
    }

    public PipelineEventReader<CharacterEventReader, CharacterEvent> getEventReader(HttpServletRequest request, HttpServletResponse response) {
        XMLEventWriter xmlEventWriter;
        PipelineEventReader eventReader = this.wrappedComponent.getEventReader(request, response);
        StringWriter writer = new StringWriter();
        XMLOutputFactory outputFactory = this.xmlUtilities.getHtmlOutputFactory();
        try {
            xmlEventWriter = outputFactory.createXMLEventWriter(writer);
        }
        catch (XMLStreamException e) {
            throw new RuntimeException("Failed to create XMLEventWriter", e);
        }
        XMLEventReader xmlEventReader = (XMLEventReader)eventReader.getEventReader();
        ChunkingEventReader chunkingEventReader = new ChunkingEventReader(request, this.chunkingElements, this.chunkingPatternEventSources, this.chunkingPatterns, xmlEventReader, xmlEventWriter, writer);
        try {
            xmlEventWriter.add((XMLEventReader)chunkingEventReader);
            xmlEventWriter.flush();
            xmlEventWriter.close();
            chunkingEventReader.close();
        }
        catch (XMLStreamException e) {
            throw new RuntimeException("Failed to write events to Writer", e);
        }
        List characterEvents = chunkingEventReader.getCharacterEvents();
        CharacterEventBufferReader characterEventReader = new CharacterEventBufferReader(characterEvents.listIterator());
        Map outputProperties = eventReader.getOutputProperties();
        return new PipelineEventReaderImpl((Object)characterEventReader, outputProperties);
    }

    public CacheKey getCacheKey(HttpServletRequest request, HttpServletResponse response) {
        return this.wrappedComponent.getCacheKey(request, response);
    }
}

