/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.rendering;

import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import org.jasig.portal.IUserPreferencesManager;
import org.jasig.portal.IUserProfile;
import org.jasig.portal.layout.IStylesheetUserPreferencesService;
import org.jasig.portal.layout.IUserLayoutManager;
import org.jasig.portal.layout.dao.IStylesheetDescriptorDao;
import org.jasig.portal.layout.om.ILayoutAttributeDescriptor;
import org.jasig.portal.layout.om.IStylesheetDescriptor;
import org.jasig.portal.rendering.AttributeSource;
import org.jasig.portal.user.IUserInstance;
import org.jasig.portal.user.IUserInstanceManager;
import org.jasig.portal.utils.Populator;
import org.jasig.portal.utils.cache.CacheKey;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class StylesheetAttributeSource
implements AttributeSource,
BeanNameAware {
    private final XMLEventFactory xmlEventFactory = XMLEventFactory.newFactory();
    private String name;
    protected IUserInstanceManager userInstanceManager;
    protected IStylesheetDescriptorDao stylesheetDescriptorDao;
    protected IStylesheetUserPreferencesService stylesheetUserPreferencesService;

    @Autowired
    public void setUserInstanceManager(IUserInstanceManager userInstanceManager) {
        this.userInstanceManager = userInstanceManager;
    }

    @Autowired
    public void setStylesheetDescriptorDao(IStylesheetDescriptorDao stylesheetDescriptorDao) {
        this.stylesheetDescriptorDao = stylesheetDescriptorDao;
    }

    @Autowired
    public void setStylesheetUserPreferencesService(IStylesheetUserPreferencesService stylesheetUserPreferencesService) {
        this.stylesheetUserPreferencesService = stylesheetUserPreferencesService;
    }

    public void setBeanName(String name) {
        this.name = name;
    }

    public final Iterator<Attribute> getAdditionalAttributes(HttpServletRequest request, HttpServletResponse response, StartElement event) {
        IStylesheetDescriptor stylesheetDescriptor = this.getStylesheetDescriptor(request);
        IStylesheetUserPreferencesService.PreferencesScope stylesheetPreferencesScope = this.getStylesheetPreferencesScope(request);
        LinkedList<Attribute> attributes = new LinkedList<Attribute>();
        for (ILayoutAttributeDescriptor layoutAttributeDescriptor : stylesheetDescriptor.getLayoutAttributeDescriptors()) {
            String name;
            QName eventName;
            String localEventName;
            Set targetElementNames = layoutAttributeDescriptor.getTargetElementNames();
            if (!targetElementNames.contains(localEventName = (eventName = event.getName()).getLocalPart())) continue;
            Attribute subscribeIdAttr = event.getAttributeByName(IUserLayoutManager.ID_ATTR_NAME);
            String subscribeId = subscribeIdAttr.getValue();
            String value = this.stylesheetUserPreferencesService.getLayoutAttribute(request, stylesheetPreferencesScope, subscribeId, name = layoutAttributeDescriptor.getName());
            if (value == null) {
                value = layoutAttributeDescriptor.getDefaultValue();
            }
            if (value == null) continue;
            Attribute attribute = this.xmlEventFactory.createAttribute(name, value);
            attributes.add(attribute);
        }
        return attributes.iterator();
    }

    public final CacheKey getCacheKey(HttpServletRequest request, HttpServletResponse response) {
        IStylesheetUserPreferencesService.PreferencesScope stylesheetPreferencesScope = this.getStylesheetPreferencesScope(request);
        CacheKey.CacheKeyBuilder cacheKeyBuilder = CacheKey.builder((String)this.name);
        Iterable layoutAttributeNodeIds = this.stylesheetUserPreferencesService.getAllLayoutAttributeNodeIds(request, stylesheetPreferencesScope);
        for (String nodeId : layoutAttributeNodeIds) {
            cacheKeyBuilder.add((Serializable)((Object)nodeId));
            this.stylesheetUserPreferencesService.populateLayoutAttributes(request, stylesheetPreferencesScope, nodeId, (Populator)cacheKeyBuilder);
        }
        return cacheKeyBuilder.build();
    }

    public IStylesheetDescriptor getStylesheetDescriptor(HttpServletRequest request) {
        IUserInstance userInstance = this.userInstanceManager.getUserInstance(request);
        IUserPreferencesManager preferencesManager = userInstance.getPreferencesManager();
        IUserProfile userProfile = preferencesManager.getUserProfile();
        IStylesheetUserPreferencesService.PreferencesScope stylesheetPreferencesScope = this.getStylesheetPreferencesScope(request);
        int stylesheetId = stylesheetPreferencesScope.getStylesheetId(userProfile);
        return this.stylesheetDescriptorDao.getStylesheetDescriptor((long)stylesheetId);
    }

    public abstract IStylesheetUserPreferencesService.PreferencesScope getStylesheetPreferencesScope(HttpServletRequest var1);
}

