/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.rendering;

import java.util.Map;
import javax.portlet.WindowState;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.XMLEvent;
import org.jasig.portal.layout.om.IStylesheetDescriptor;
import org.jasig.portal.layout.om.IStylesheetParameterDescriptor;
import org.jasig.portal.portlet.PortletUtils;
import org.jasig.portal.portlet.registry.IPortletWindowRegistry;
import org.jasig.portal.rendering.PipelineEventReader;
import org.jasig.portal.rendering.PipelineEventReaderImpl;
import org.jasig.portal.rendering.StAXPipelineComponentWrapper;
import org.jasig.portal.rendering.StylesheetAttributeSource;
import org.jasig.portal.rendering.WindowStateSettingsStAXComponent;
import org.jasig.portal.url.IPortalRequestInfo;
import org.jasig.portal.url.IUrlSyntaxProvider;
import org.jasig.portal.utils.cache.CacheKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class WindowStateSettingsStAXComponent
extends StAXPipelineComponentWrapper {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private IUrlSyntaxProvider urlSyntaxProvider;
    private IPortletWindowRegistry portletWindowRegistry;
    private StylesheetAttributeSource stylesheetAttributeSource;

    @Autowired
    public void setPortletWindowRegistry(IPortletWindowRegistry portletWindowRegistry) {
        this.portletWindowRegistry = portletWindowRegistry;
    }

    @Autowired
    public void setUrlSyntaxProvider(IUrlSyntaxProvider urlSyntaxProvider) {
        this.urlSyntaxProvider = urlSyntaxProvider;
    }

    public void setStylesheetAttributeSource(StylesheetAttributeSource stylesheetAttributeSource) {
        this.stylesheetAttributeSource = stylesheetAttributeSource;
    }

    public CacheKey getCacheKey(HttpServletRequest request, HttpServletResponse response) {
        return this.wrappedComponent.getCacheKey(request, response);
    }

    public PipelineEventReader<XMLEventReader, XMLEvent> getEventReader(HttpServletRequest request, HttpServletResponse response) {
        XMLEventReader filteredEventReader;
        PipelineEventReader pipelineEventReader = this.wrappedComponent.getEventReader(request, response);
        XMLEventReader eventReader = (XMLEventReader)pipelineEventReader.getEventReader();
        IStylesheetDescriptor stylesheetDescriptor = this.stylesheetAttributeSource.getStylesheetDescriptor(request);
        IPortalRequestInfo portalRequestInfo = this.urlSyntaxProvider.getPortalRequestInfo(request);
        if (portalRequestInfo.getTargetedPortletWindowId() == null) {
            IStylesheetParameterDescriptor defaultWindowStateParam = stylesheetDescriptor.getStylesheetParameterDescriptor("dashboardForcedWindowState");
            if (defaultWindowStateParam != null) {
                WindowState windowState = PortletUtils.getWindowState((String)defaultWindowStateParam.getDefaultValue());
                filteredEventReader = new SinglePortletWindowStateSettingXMLEventReader(this, request, eventReader, windowState);
            } else {
                filteredEventReader = new NonTargetedPortletWindowStateSettingXMLEventReader(this, request, eventReader);
            }
        } else {
            filteredEventReader = eventReader;
        }
        Map outputProperties = pipelineEventReader.getOutputProperties();
        return new PipelineEventReaderImpl((Object)filteredEventReader, outputProperties);
    }

    static /* synthetic */ IPortletWindowRegistry access$000(WindowStateSettingsStAXComponent x0) {
        return x0.portletWindowRegistry;
    }
}

