/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.rendering.xslt;

import java.io.IOException;
import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import org.jasig.portal.IUserPreferencesManager;
import org.jasig.portal.layout.dao.IStylesheetDescriptorDao;
import org.jasig.portal.layout.om.IStylesheetDescriptor;
import org.jasig.portal.rendering.xslt.TransformerSource;
import org.jasig.portal.user.IUserInstance;
import org.jasig.portal.user.IUserInstanceManager;
import org.jasig.portal.utils.cache.CacheKey;
import org.jasig.portal.xml.XmlUtilities;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

public abstract class BaseTransformerSource
implements TransformerSource,
ResourceLoaderAware {
    private IUserInstanceManager userInstanceManager;
    private XmlUtilities xmlUtilities;
    private ResourceLoader resourceLoader;
    protected IStylesheetDescriptorDao stylesheetDescriptorDao;

    @Autowired
    public void setStylesheetDescriptorDao(IStylesheetDescriptorDao stylesheetDescriptorDao) {
        this.stylesheetDescriptorDao = stylesheetDescriptorDao;
    }

    @Autowired
    public void setUserInstanceManager(IUserInstanceManager userInstanceManager) {
        this.userInstanceManager = userInstanceManager;
    }

    @Autowired
    public void setXmlUtilities(XmlUtilities xmlUtilities) {
        this.xmlUtilities = xmlUtilities;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public final CacheKey getCacheKey(HttpServletRequest request, HttpServletResponse response) {
        Serializable stylesheetCacheKey;
        Resource stylesheetResource = this.getStylesheetResource(request);
        try {
            stylesheetCacheKey = this.xmlUtilities.getStylesheetCacheKey(stylesheetResource);
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException("Failed to get Transformer for stylesheet: " + stylesheetResource, e);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load stylesheet: " + stylesheetResource, e);
        }
        return CacheKey.build((String)stylesheetResource.getDescription(), (Serializable[])new Serializable[]{stylesheetCacheKey});
    }

    public final Transformer getTransformer(HttpServletRequest request, HttpServletResponse response) {
        Resource stylesheetResource = this.getStylesheetResource(request);
        try {
            return this.xmlUtilities.getTransformer(stylesheetResource);
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException("Failed to get Transformer for stylesheet: " + stylesheetResource, e);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load stylesheet: " + stylesheetResource, e);
        }
    }

    protected abstract long getStylesheetDescriptorId(IUserPreferencesManager var1);

    private Resource getStylesheetResource(HttpServletRequest request) {
        IUserInstance userInstance = this.userInstanceManager.getUserInstance(request);
        IUserPreferencesManager preferencesManager = userInstance.getPreferencesManager();
        long stylesheetDescriptorId = this.getStylesheetDescriptorId(preferencesManager);
        IStylesheetDescriptor stylesheetDescriptor = this.stylesheetDescriptorDao.getStylesheetDescriptor(stylesheetDescriptorId);
        String stylesheetResource = stylesheetDescriptor.getStylesheetResource();
        return this.resourceLoader.getResource(stylesheetResource);
    }
}

