/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.rendering.xslt;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jasig.portal.rendering.xslt.TransformerConfigurationSource;
import org.jasig.portal.utils.cache.CacheKey;

public class MergingTransformerConfigurationSource
implements TransformerConfigurationSource {
    private List<TransformerConfigurationSource> sources;

    public void setSources(List<TransformerConfigurationSource> sources) {
        this.sources = sources;
    }

    public CacheKey getCacheKey(HttpServletRequest request, HttpServletResponse response) {
        CacheKey.CacheKeyBuilder cacheKeyBuilder = CacheKey.builder((String)this.getClass().getName());
        for (TransformerConfigurationSource source : this.sources) {
            CacheKey key = source.getCacheKey(request, response);
            cacheKeyBuilder.add((Serializable)key);
        }
        return cacheKeyBuilder.build();
    }

    public Properties getOutputProperties(HttpServletRequest request, HttpServletResponse response) {
        Properties mergedProperties = new Properties();
        for (TransformerConfigurationSource source : this.sources) {
            Properties properties = source.getOutputProperties(request, response);
            if (properties == null) continue;
            mergedProperties.putAll((Map<?, ?>)properties);
        }
        return mergedProperties;
    }

    public Map<String, Object> getParameters(HttpServletRequest request, HttpServletResponse response) {
        LinkedHashMap<String, Object> mergedParameters = new LinkedHashMap<String, Object>();
        for (TransformerConfigurationSource source : this.sources) {
            Map parameters = source.getParameters(request, response);
            if (parameters == null) continue;
            mergedParameters.putAll(parameters);
        }
        return mergedParameters;
    }
}

