/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.rendering.xslt;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.jasig.portal.layout.IStylesheetUserPreferencesService;
import org.jasig.portal.layout.om.IStylesheetDescriptor;
import org.jasig.portal.rendering.xslt.SkinMappingTransformerConfigurationSource;
import org.jasig.portal.rendering.xslt.TransformerConfigurationSourceAdapter;
import org.jasig.portal.utils.cache.CacheKey;
import org.jasig.resourceserver.aggr.om.Included;
import org.jasig.resourceserver.utils.aggr.ResourcesElementsProvider;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.annotation.Autowired;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class SkinMappingTransformerConfigurationSource
extends TransformerConfigurationSourceAdapter
implements BeanNameAware {
    private IStylesheetUserPreferencesService stylesheetUserPreferencesService;
    private ResourcesElementsProvider resourcesElementsProvider;
    private String skinNameAttribute;
    private String skinParameterName = "skin";
    private Set<String> stylesheetDescriptorNames;
    private boolean cacheSkinResolution = true;

    public void setSkinParameterName(String skinParameterName) {
        this.skinParameterName = skinParameterName;
    }

    @Autowired
    public void setResourcesElementsProvider(ResourcesElementsProvider resourcesElementsProvider) {
        this.resourcesElementsProvider = resourcesElementsProvider;
    }

    @Autowired
    public void setStylesheetUserPreferencesService(IStylesheetUserPreferencesService stylesheetUserPreferencesService) {
        this.stylesheetUserPreferencesService = stylesheetUserPreferencesService;
    }

    public void setCacheSkinResolution(boolean cacheSkinResolution) {
        this.cacheSkinResolution = cacheSkinResolution;
    }

    public void setStylesheetDescriptorNames(Set<String> stylesheetDescriptorNames) {
        this.stylesheetDescriptorNames = ImmutableSet.copyOf(stylesheetDescriptorNames);
    }

    public void setBeanName(String name) {
        this.skinNameAttribute = name + ".SKIN_NAME";
    }

    public final Map<String, Object> getParameters(HttpServletRequest request, HttpServletResponse response) {
        String skinName = this.getSkinNameInternal(request);
        if (skinName == null) {
            return Collections.emptyMap();
        }
        return ImmutableMap.of((Object)this.skinParameterName, (Object)skinName);
    }

    public final CacheKey getCacheKey(HttpServletRequest request, HttpServletResponse response) {
        String skinName = this.getSkinNameInternal(request);
        return CacheKey.build((String)this.getClass().getName(), (Serializable[])new Serializable[]{skinName});
    }

    private String getSkinNameInternal(HttpServletRequest request) {
        if (!this.cacheSkinResolution || Included.PLAIN == this.resourcesElementsProvider.getDefaultIncludedType()) {
            if (!this.shouldOverrideSkin(request)) {
                return null;
            }
            return this.getSkinName(request);
        }
        HttpSession session = request.getSession();
        SkinNameHolder skinNameHolder = (SkinNameHolder)session.getAttribute(this.skinNameAttribute);
        if (skinNameHolder == null) {
            String skinName = this.shouldOverrideSkin(request) ? this.getSkinName(request) : null;
            skinNameHolder = new SkinNameHolder(skinName);
            session.setAttribute(this.skinNameAttribute, (Object)skinNameHolder);
        }
        return SkinNameHolder.access$000((SkinNameHolder)skinNameHolder);
    }

    protected boolean shouldOverrideSkin(HttpServletRequest request) {
        if (this.stylesheetDescriptorNames == null || this.stylesheetDescriptorNames.isEmpty()) {
            return true;
        }
        IStylesheetDescriptor stylesheetDescriptor = this.stylesheetUserPreferencesService.getStylesheetDescriptor(request, IStylesheetUserPreferencesService.PreferencesScope.THEME);
        return this.stylesheetDescriptorNames.contains(stylesheetDescriptor.getName());
    }

    protected abstract String getSkinName(HttpServletRequest var1);
}

