/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.rendering.xslt;

import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jasig.portal.rendering.xslt.TransformerConfigurationSource;
import org.jasig.portal.spring.spel.IPortalSpELService;
import org.jasig.portal.utils.cache.CacheKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.expression.Expression;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.context.request.WebRequest;

public class StaticTransformerConfigurationSource
implements TransformerConfigurationSource {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Properties outputProperties;
    private LinkedHashMap<String, Object> parameters;
    private IPortalSpELService portalSpELService;
    private Map<String, Expression> parameterExpressions;
    private Set<String> cacheKeyExcludedParameters = Collections.emptySet();

    @Autowired
    public void setPortalSpELService(IPortalSpELService portalSpELService) {
        this.portalSpELService = portalSpELService;
    }

    public void setProperties(Properties transformerOutputProperties) {
        this.outputProperties = transformerOutputProperties;
    }

    public void setParameters(Map<String, Object> transformerParameters) {
        this.parameters = new LinkedHashMap<String, Object>(transformerParameters);
    }

    public void setParameterExpressions(Map<String, String> parameterExpressions) {
        LinkedHashMap<String, Expression> parameterExpressionsBuilder = new LinkedHashMap<String, Expression>();
        for (Map.Entry<String, String> expressionEntry : parameterExpressions.entrySet()) {
            String string = expressionEntry.getValue();
            Expression expression = this.portalSpELService.parseExpression(string);
            parameterExpressionsBuilder.put(expressionEntry.getKey(), expression);
        }
        this.parameterExpressions = parameterExpressionsBuilder;
    }

    public void setCacheKeyExcludedParameters(Set<String> cacheKeyExcludedParameters) {
        this.cacheKeyExcludedParameters = cacheKeyExcludedParameters;
    }

    public CacheKey getCacheKey(HttpServletRequest request, HttpServletResponse response) {
        LinkedHashMap transformerParameters = this.getParameters(request, response);
        transformerParameters.keySet().removeAll(this.cacheKeyExcludedParameters);
        return CacheKey.build((String)this.getClass().getName(), (Serializable[])new Serializable[]{this.outputProperties, transformerParameters});
    }

    public Properties getOutputProperties(HttpServletRequest request, HttpServletResponse response) {
        this.logger.debug("Returning output properties: {}", (Object)this.outputProperties);
        return this.outputProperties;
    }

    public LinkedHashMap<String, Object> getParameters(HttpServletRequest request, HttpServletResponse response) {
        ServletWebRequest webRequest = new ServletWebRequest(request, response);
        LinkedHashMap<String, Object> parameters = new LinkedHashMap<String, Object>(this.parameters);
        if (this.parameterExpressions != null) {
            for (Map.Entry expressionEntry : this.parameterExpressions.entrySet()) {
                Expression expression = (Expression)expressionEntry.getValue();
                Object value = this.portalSpELService.getValue(expression, (WebRequest)webRequest);
                if (value == null) continue;
                parameters.put((String)expressionEntry.getKey(), value);
            }
        }
        this.logger.debug("Returning transformer parameters: {}", parameters);
        return parameters;
    }
}

