/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.rendering.xslt;

import java.util.Collections;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.jasig.portal.EntityIdentifier;
import org.jasig.portal.groups.IGroupMember;
import org.jasig.portal.rendering.xslt.SkinMappingTransformerConfigurationSource;
import org.jasig.portal.rendering.xslt.UserGroupSkinMappingTransformerConfigurationSource;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.services.GroupService;
import org.jasig.portal.user.IUserInstance;
import org.jasig.portal.user.IUserInstanceManager;
import org.jasig.portal.utils.threading.SingletonDoubleCheckedCreator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class UserGroupSkinMappingTransformerConfigurationSource
extends SkinMappingTransformerConfigurationSource {
    private final SingletonDoubleCheckedCreator<Map<IGroupMember, String>> groupMemberToSkinMappingCreator = new GroupMemberMappingCreator(this, null);
    private IUserInstanceManager userInstanceManager;
    private Map<String, String> groupToSkinMap = Collections.emptyMap();
    private static final String LOGGER_NAME = UserGroupSkinMappingTransformerConfigurationSource.class.getName();
    private Logger logger;

    protected Logger getLogger() {
        Logger l = this.logger;
        if (l == null) {
            this.logger = l = LoggerFactory.getLogger((String)LOGGER_NAME);
        }
        return l;
    }

    @Autowired
    public void setUserInstanceManager(IUserInstanceManager userInstanceManager) {
        this.userInstanceManager = userInstanceManager;
    }

    public void setGroupToSkinMap(Map<String, String> groupToSkinMap) {
        this.groupToSkinMap = groupToSkinMap;
    }

    protected String getSkinName(HttpServletRequest request) {
        IUserInstance userInstance = this.userInstanceManager.getUserInstance(request);
        IPerson person = userInstance.getPerson();
        EntityIdentifier personIdentifier = person.getEntityIdentifier();
        IGroupMember groupMember = GroupService.getGroupMember((EntityIdentifier)personIdentifier);
        Map groupMemberToSkinMapping = (Map)this.groupMemberToSkinMappingCreator.get(new Object[0]);
        for (Map.Entry groupToSkinEntry : groupMemberToSkinMapping.entrySet()) {
            IGroupMember group = (IGroupMember)groupToSkinEntry.getKey();
            if (!groupMember.isDeepMemberOf(group)) continue;
            String skin = (String)groupToSkinEntry.getValue();
            this.getLogger().debug("Setting skin override {} for {} because they are a member of {}", new Object[]{skin, person.getUserName(), group});
            return skin;
        }
        this.getLogger().debug("No user {} is not a member of any configured groups, no skin override will be done", (Object)person.getUserName());
        return null;
    }

    static /* synthetic */ Map access$100(UserGroupSkinMappingTransformerConfigurationSource x0) {
        return x0.groupToSkinMap;
    }
}

