/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.rendering.xslt;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jasig.portal.rendering.xslt.TransformerConfigurationSource;
import org.jasig.portal.security.IdentitySwapperManager;
import org.jasig.portal.utils.cache.CacheKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class UserImpersonationTransformerConfigurationSource
implements TransformerConfigurationSource {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String userImpersonatingParameter = "userImpersonating";
    private IdentitySwapperManager identitySwapperManager;

    @Autowired
    public void setIdentitySwapperManager(IdentitySwapperManager identitySwapperManager) {
        this.identitySwapperManager = identitySwapperManager;
    }

    public void setUserImpersonatingParameter(String userImpersonatingParameter) {
        this.userImpersonatingParameter = userImpersonatingParameter;
    }

    public CacheKey getCacheKey(HttpServletRequest request, HttpServletResponse response) {
        boolean impersonating = this.identitySwapperManager.isImpersonating(request);
        return CacheKey.build((String)UserImpersonationTransformerConfigurationSource.class.getName(), (Serializable[])new Serializable[]{this.userImpersonatingParameter, Boolean.valueOf(impersonating)});
    }

    public Properties getOutputProperties(HttpServletRequest request, HttpServletResponse response) {
        return null;
    }

    public Map<String, Object> getParameters(HttpServletRequest request, HttpServletResponse response) {
        boolean impersonating = this.identitySwapperManager.isImpersonating(request);
        Map<String, Object> parameters = Collections.singletonMap(this.userImpersonatingParameter, impersonating);
        this.logger.debug("Returning transformer parameters: {}", parameters);
        return parameters;
    }
}

