/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.rendering.xslt;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.XMLEvent;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stax.StAXSource;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.rendering.PipelineEventReader;
import org.jasig.portal.rendering.PipelineEventReaderImpl;
import org.jasig.portal.rendering.StAXPipelineComponentWrapper;
import org.jasig.portal.rendering.xslt.TransformerConfigurationSource;
import org.jasig.portal.rendering.xslt.TransformerSource;
import org.jasig.portal.utils.cache.CacheKey;
import org.jasig.portal.xml.ResourceLoaderURIResolver;
import org.jasig.portal.xml.StaxUtils;
import org.jasig.portal.xml.stream.XMLEventBufferReader;
import org.jasig.portal.xml.stream.XMLEventBufferWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.xml.FixedXMLEventStreamReader;
import org.springframework.util.xml.SimpleTransformErrorListener;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.LocatorImpl;

public class XSLTComponent
extends StAXPipelineComponentWrapper
implements BeanNameAware,
ResourceLoaderAware {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ErrorListener errorListener = new SimpleTransformErrorListener(LogFactory.getLog(this.getClass()));
    private ResourceLoaderURIResolver uriResolver;
    private TransformerSource transformerSource;
    private TransformerConfigurationSource xsltParameterSource;
    private String beanName;

    public void setXsltParameterSource(TransformerConfigurationSource xsltParameterSource) {
        this.xsltParameterSource = xsltParameterSource;
    }

    public void setTransformerSource(TransformerSource transformerSource) {
        this.transformerSource = transformerSource;
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.uriResolver = new ResourceLoaderURIResolver(resourceLoader);
    }

    public PipelineEventReader<XMLEventReader, XMLEvent> getEventReader(HttpServletRequest request, HttpServletResponse response) {
        FixedXMLEventStreamReader streamReader;
        PipelineEventReader pipelineEventReader = this.wrappedComponent.getEventReader(request, response);
        Transformer transformer = this.transformerSource.getTransformer(request, response);
        transformer.setURIResolver((URIResolver)this.uriResolver);
        if (this.xsltParameterSource != null) {
            Properties outputProperties;
            Map transformerParameters = this.xsltParameterSource.getParameters(request, response);
            if (transformerParameters != null) {
                this.logger.debug("{} - Setting Transformer Parameters: ", (Object)this.beanName, (Object)transformerParameters);
                for (Map.Entry transformerParametersEntry : transformerParameters.entrySet()) {
                    String name = (String)transformerParametersEntry.getKey();
                    Object value = transformerParametersEntry.getValue();
                    if (value == null) continue;
                    transformer.setParameter(name, value);
                }
            }
            if ((outputProperties = this.xsltParameterSource.getOutputProperties(request, response)) != null) {
                this.logger.debug("{} - Setting Transformer Output Properties: ", (Object)this.beanName, (Object)outputProperties);
                transformer.setOutputProperties(outputProperties);
            }
        }
        XMLEventReader eventReader = (XMLEventReader)pipelineEventReader.getEventReader();
        try {
            streamReader = new FixedXMLEventStreamReader(eventReader);
        }
        catch (XMLStreamException e) {
            throw new RuntimeException("Failed to create XMLStreamReader from XMLEventReader", e);
        }
        StAXSource xmlReaderSource = new StAXSource((XMLStreamReader)streamReader);
        transformer.setErrorListener(this.errorListener);
        XMLEventBufferWriter eventWriterBuffer = new XMLEventBufferWriter();
        ContentHandler contentHandler = StaxUtils.createLexicalContentHandler((XMLEventWriter)eventWriterBuffer);
        contentHandler.setDocumentLocator(new LocatorImpl());
        SAXResult outputTarget = new SAXResult(contentHandler);
        try {
            this.logger.debug("{} - Begining XML Transformation", (Object)this.beanName);
            transformer.transform(xmlReaderSource, outputTarget);
            this.logger.debug("{} - XML Transformation complete", (Object)this.beanName);
        }
        catch (TransformerException e) {
            throw new RuntimeException("Failed to transform document", e);
        }
        String mediaType = transformer.getOutputProperty("media-type");
        List eventBuffer = eventWriterBuffer.getEventBuffer();
        XMLEventBufferReader outputEventReader = new XMLEventBufferReader(eventBuffer.listIterator());
        Map outputProperties = pipelineEventReader.getOutputProperties();
        PipelineEventReaderImpl pipelineEventReaderImpl = new PipelineEventReaderImpl((Object)outputEventReader, outputProperties);
        pipelineEventReaderImpl.setOutputProperty("media-type", mediaType);
        return pipelineEventReaderImpl;
    }

    public CacheKey getCacheKey(HttpServletRequest request, HttpServletResponse response) {
        CacheKey parentCacheKey = this.wrappedComponent.getCacheKey(request, response);
        CacheKey transformerKey = this.transformerSource != null ? this.transformerSource.getCacheKey(request, response) : null;
        CacheKey transformerConfigurationKey = this.xsltParameterSource != null ? this.xsltParameterSource.getCacheKey(request, response) : null;
        return CacheKey.build((String)this.beanName, (Serializable[])new Serializable[]{parentCacheKey, transformerKey, transformerConfigurationKey});
    }
}

