/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.rest;

import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.jasig.portal.portlets.lookup.PersonLookupHelperImpl;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.security.IPersonManager;
import org.jasig.services.persondir.IPersonAttributes;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PeopleRESTController {
    private IPersonManager personManager;
    private PersonLookupHelperImpl lookupHelper;

    @Autowired
    public void setPersonManager(IPersonManager personManager) {
        this.personManager = personManager;
    }

    @Autowired(required=true)
    public void setPersonLookupHelper(PersonLookupHelperImpl lookupHelper) {
        this.lookupHelper = lookupHelper;
    }

    @RequestMapping(value={"/people.json"}, method={RequestMethod.GET})
    public ModelAndView getPeople(@RequestParam(value="searchTerms[]") List<String> searchTerms, HttpServletRequest request, HttpServletResponse response) {
        IPerson person = this.personManager.getPerson(request);
        if (person == null) {
            response.setStatus(401);
            return null;
        }
        HashMap<String, String> query = new HashMap<String, String>();
        for (String term : searchTerms) {
            String search = request.getParameter(term);
            if (!StringUtils.isNotBlank((String)search)) continue;
            query.put(term, search);
        }
        List people = this.lookupHelper.searchForPeople(person, query);
        ModelAndView mv = new ModelAndView();
        mv.addObject("people", (Object)people);
        mv.setViewName("json");
        return mv;
    }

    @RequestMapping(value={"/people/{username}.json"}, method={RequestMethod.GET})
    public ModelAndView getPerson(@PathVariable String username, HttpServletRequest request, HttpServletResponse response) {
        IPerson searcher = this.personManager.getPerson(request);
        if (searcher == null) {
            response.setStatus(401);
            return null;
        }
        IPersonAttributes person = this.lookupHelper.findPerson(searcher, username);
        ModelAndView mv = new ModelAndView();
        mv.addObject("person", (Object)person);
        mv.setViewName("json");
        return mv;
    }
}

