/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.rest;

import java.util.ArrayList;
import java.util.Collections;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jasig.portal.layout.dlm.remoting.IGroupListHelper;
import org.jasig.portal.portlets.groupselector.EntityEnum;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PrincipalsRESTController {
    private IGroupListHelper listHelper;

    @Autowired(required=true)
    public void setGroupListHelper(IGroupListHelper groupListHelper) {
        this.listHelper = groupListHelper;
    }

    @PreAuthorize(value="hasPermission('string', 'REST', new org.jasig.portal.spring.security.evaluator.AuthorizableActivity('UP_PERMISSIONS', 'VIEW_PERMISSIONS'))")
    @RequestMapping(value={"/permissions/principals.json"}, method={RequestMethod.GET})
    public ModelAndView getPrincipals(@RequestParam(value="q") String query, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ModelAndView mv = new ModelAndView();
        ArrayList groups = new ArrayList();
        groups.addAll(this.listHelper.search(EntityEnum.GROUP.toString(), query));
        Collections.sort(groups);
        mv.addObject("groups", groups);
        ArrayList people = new ArrayList();
        people.addAll(this.listHelper.search(EntityEnum.PERSON.toString(), query));
        Collections.sort(people);
        mv.addObject("people", people);
        mv.setViewName("json");
        return mv;
    }
}

