/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.rest;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.jasig.portal.fragment.subscribe.IUserFragmentSubscription;
import org.jasig.portal.fragment.subscribe.dao.IUserFragmentSubscriptionDao;
import org.jasig.portal.layout.dlm.ConfigurationLoader;
import org.jasig.portal.layout.dlm.Evaluator;
import org.jasig.portal.layout.dlm.FragmentDefinition;
import org.jasig.portal.layout.dlm.providers.SubscribedTabEvaluatorFactory;
import org.jasig.portal.rest.SubscribableTabsRESTController;
import org.jasig.portal.security.IAuthorizationPrincipal;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.services.AuthorizationService;
import org.jasig.portal.user.IUserInstance;
import org.jasig.portal.user.IUserInstanceManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.support.RequestContextUtils;

@Controller
public class SubscribableTabsRESTController {
    @Autowired
    @Qualifier(value="userInstanceManager")
    private IUserInstanceManager userInstanceManager;
    private IUserFragmentSubscriptionDao userFragmentSubscriptionDao;
    @Autowired
    @Qualifier(value="dlmConfigurationLoader")
    private ConfigurationLoader configurationLoader;
    @Autowired
    private MessageSource messageSource;

    public void setUserInstanceManager(IUserInstanceManager userInstanceManager) {
        this.userInstanceManager = userInstanceManager;
    }

    @Autowired(required=true)
    public void setUserFragmentSubscriptionDao(IUserFragmentSubscriptionDao userFragmentSubscriptionDao) {
        this.userFragmentSubscriptionDao = userFragmentSubscriptionDao;
    }

    @RequestMapping(value={"/subscribableTabs.json"}, method={RequestMethod.GET})
    public ModelAndView getSubscriptionList(HttpServletRequest request) {
        HashMap model = new HashMap();
        IUserInstance userInstance = this.userInstanceManager.getUserInstance(request);
        IPerson person = userInstance.getPerson();
        AuthorizationService authService = AuthorizationService.instance();
        IAuthorizationPrincipal principal = authService.newPrincipal(person.getUserName(), IPerson.class);
        List subscriptions = this.userFragmentSubscriptionDao.getUserFragmentInfo(person);
        HashSet<String> subscribedOwners = new HashSet<String>();
        for (IUserFragmentSubscription subscription : subscriptions) {
            if (!subscription.isActive()) continue;
            subscribedOwners.add(subscription.getFragmentOwner());
        }
        ArrayList<SubscribableFragment> jsonFragments = new ArrayList<SubscribableFragment>();
        List fragmentDefinitions = this.configurationLoader.getFragments();
        Locale locale = RequestContextUtils.getLocale((HttpServletRequest)request);
        for (FragmentDefinition fragmentDefinition : fragmentDefinitions) {
            String owner;
            if (!this.isSubscribable(fragmentDefinition, principal) || !principal.hasPermission("UP_FRAGMENT", "FRAGMENT_SUBSCRIBE", owner = fragmentDefinition.getOwnerId())) continue;
            boolean subscribed = subscribedOwners.contains(owner);
            String name = this.getMessage("fragment." + owner + ".name", fragmentDefinition.getName(), locale);
            String description = this.getMessage("fragment." + owner + ".description", fragmentDefinition.getDescription(), locale);
            SubscribableFragment jsonFragment = new SubscribableFragment(this, name, description, owner, subscribed);
            jsonFragments.add(jsonFragment);
        }
        model.put("fragments", jsonFragments);
        return new ModelAndView("json", model);
    }

    protected boolean isSubscribable(FragmentDefinition definition, IAuthorizationPrincipal principal) {
        String owner = definition.getOwnerId();
        for (Evaluator evaluator : definition.getEvaluators()) {
            if (!evaluator.getFactoryClass().equals(SubscribedTabEvaluatorFactory.class)) continue;
            return principal.hasPermission("UP_FRAGMENT", "FRAGMENT_SUBSCRIBE", owner);
        }
        return false;
    }

    protected String getMessage(String key, String defaultName, Locale locale) {
        return this.messageSource.getMessage(key, new Object[0], defaultName, locale);
    }
}

