/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.security;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.commons.lang.StringUtils;
import org.jasig.portal.persondir.ILocalAccountDao;
import org.jasig.portal.persondir.ILocalAccountPerson;
import org.jasig.portal.security.IPasswordUpdateTool;
import org.jasig.portal.security.IPortalPasswordService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="passwordUpdateTool")
public class CliPasswordUpdateTool
implements IPasswordUpdateTool {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ILocalAccountDao localAccountDao;
    private IPortalPasswordService portalPasswordService;

    @Autowired
    public void setLocalAccountDao(ILocalAccountDao localAccountDao) {
        this.localAccountDao = localAccountDao;
    }

    @Autowired
    public void setPortalPasswordService(IPortalPasswordService portalPasswordService) {
        this.portalPasswordService = portalPasswordService;
    }

    @Transactional
    public boolean updatePassword(String user, boolean create) throws IOException {
        if (StringUtils.isBlank((String)user)) {
            System.err.println("You did not specify a valid user name.  Please try again.");
            return false;
        }
        ILocalAccountPerson account = this.localAccountDao.getPerson(user);
        if (account == null) {
            if (!create) {
                System.err.println("No such user: " + user);
                return false;
            }
            account = this.localAccountDao.createPerson(user);
        }
        System.out.print("Enter Password for " + user + ": ");
        System.out.flush();
        BufferedReader d = new BufferedReader(new InputStreamReader(System.in));
        String spass = d.readLine();
        String encryptedPassword = this.portalPasswordService.encryptPassword(spass);
        account.setPassword(encryptedPassword);
        this.localAccountDao.updateAccount(account);
        System.out.println("Password Updated...");
        return true;
    }

    @Transactional
    public void updatePassword(String user, String spass, boolean create) throws IOException {
        if (StringUtils.isBlank((String)user)) {
            throw new IllegalArgumentException("You did not specify a valid user name.  Please try again.");
        }
        ILocalAccountPerson account = this.localAccountDao.getPerson(user);
        if (account == null) {
            if (!create) {
                throw new IllegalArgumentException("No such user: " + user);
            }
            account = this.localAccountDao.createPerson(user);
        }
        String encryptedPassword = this.portalPasswordService.encryptPassword(spass);
        account.setPassword(encryptedPassword);
        this.localAccountDao.updateAccount(account);
        this.logger.info("Password Updated for: {}", (Object)user);
    }
}

