/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.security;

import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.jasig.portal.EntityIdentifier;
import org.jasig.portal.security.IAuthorizationPrincipal;
import org.jasig.portal.security.IAuthorizationService;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.security.IdentitySwapperManager;
import org.jasig.portal.security.RuntimeAuthorizationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="identitySwapperManager")
public class IdentitySwapperManagerImpl
implements IdentitySwapperManager {
    public static final String IMPERSONATE_OWNER = "UP_USERS";
    public static final String IMPERSONATE_ACTIVITY = "IMPERSONATE";
    private static final String SWAP_TARGET_UID = IdentitySwapperManagerImpl.class.getName() + ".SWAP_TARGET_UID";
    private static final String SWAP_ORIGINAL_UID = IdentitySwapperManagerImpl.class.getName() + ".SWAP_ORIGINAL_UID";
    private IAuthorizationService authorizationService;

    @Autowired
    public void setAuthorizationService(IAuthorizationService authorizationService) {
        this.authorizationService = authorizationService;
    }

    public boolean canImpersonateUser(IPerson currentUser, String targetUsername) {
        EntityIdentifier ei = currentUser.getEntityIdentifier();
        IAuthorizationPrincipal ap = this.authorizationService.newPrincipal(ei.getKey(), ei.getType());
        return this.canImpersonateUser(ap, targetUsername);
    }

    public boolean canImpersonateUser(String currentUserName, String targetUsername) {
        IAuthorizationPrincipal ap = this.authorizationService.newPrincipal(currentUserName, IPerson.class);
        return this.canImpersonateUser(ap, targetUsername);
    }

    protected boolean canImpersonateUser(IAuthorizationPrincipal ap, String targetUsername) {
        return ap.hasPermission(IMPERSONATE_OWNER, IMPERSONATE_ACTIVITY, targetUsername);
    }

    public void impersonateUser(PortletRequest portletRequest, IPerson currentUser, String targetUsername) {
        this.impersonateUser(portletRequest, currentUser.getName(), targetUsername);
    }

    public void impersonateUser(PortletRequest portletRequest, String currentUserName, String targetUsername) {
        if (!this.canImpersonateUser(currentUserName, targetUsername)) {
            throw new RuntimeAuthorizationException(currentUserName, IMPERSONATE_OWNER, targetUsername);
        }
        PortletSession portletSession = portletRequest.getPortletSession();
        portletSession.setAttribute(SWAP_TARGET_UID, (Object)targetUsername, 1);
    }

    public void setOriginalUser(HttpSession session, String currentUserName, String targetUsername) {
        if (!this.canImpersonateUser(currentUserName, targetUsername)) {
            throw new RuntimeAuthorizationException(currentUserName, IMPERSONATE_OWNER, targetUsername);
        }
        session.setAttribute(SWAP_ORIGINAL_UID, (Object)currentUserName);
    }

    public String getOriginalUsername(HttpSession session) {
        return (String)session.getAttribute(SWAP_ORIGINAL_UID);
    }

    public String getTargetUsername(HttpSession session) {
        return (String)session.getAttribute(SWAP_TARGET_UID);
    }

    public boolean isImpersonating(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session == null) {
            return false;
        }
        return this.getOriginalUsername(session) != null;
    }
}

