/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.security;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.security.BaseContextConfiguration;
import org.jasig.portal.security.ContextConfiguration;
import org.jasig.portal.security.IConfigurableSecurityContext;
import org.jasig.portal.security.ISecurityContext;
import org.jasig.portal.security.ISecurityContextFactory;
import org.jasig.portal.security.PortalSecurityException;

/*
 * Exception performing whole class analysis ignored.
 */
public class InitialSecurityContextFactory {
    private static final Log log = LogFactory.getLog(InitialSecurityContextFactory.class);
    private static final String CONTEXT_PROPERTY_PREFIX = "securityContextProperty";
    private static final Map contextConfigCache = new Hashtable();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ISecurityContext getInitialContext(String rootContext) throws PortalSecurityException {
        BaseContextConfiguration contextConfigBase;
        Map map = contextConfigCache;
        synchronized (map) {
            contextConfigBase = (BaseContextConfiguration)contextConfigCache.get(rootContext);
            if (contextConfigBase == null) {
                if (rootContext.indexOf(46) != -1) {
                    PortalSecurityException ep = new PortalSecurityException("Initial Context can't be compound");
                    log.error((Object)"Initial context cannot be compound", (Throwable)ep);
                    throw ep;
                }
                contextConfigBase = new BaseContextConfiguration();
                contextConfigCache.put(rootContext, contextConfigBase);
            }
        }
        map = contextConfigBase;
        synchronized (map) {
            if (!contextConfigBase.initialized) {
                Properties securityProperties = new Properties();
                InputStream securityPropertiesStream = null;
                try {
                    securityPropertiesStream = InitialSecurityContextFactory.class.getResourceAsStream("/properties/security.properties");
                    securityProperties.load(securityPropertiesStream);
                }
                catch (IOException e) {
                    PortalSecurityException ep = new PortalSecurityException((Throwable)e);
                    log.error((Object)"Exception loading security properties", (Throwable)ep);
                    throw ep;
                }
                finally {
                    try {
                        if (securityPropertiesStream != null) {
                            securityPropertiesStream.close();
                        }
                    }
                    catch (IOException ioe) {
                        log.error((Object)"getInitialContext() unable to close InputStream", (Throwable)ioe);
                    }
                }
                contextConfigBase.rootConfig = InitialSecurityContextFactory.loadContextConfigurationChain((String)rootContext, (Properties)securityProperties);
                contextConfigBase.initialized = true;
            }
        }
        try {
            ISecurityContext ctx = InitialSecurityContextFactory.createSecurityContextChain((ContextConfiguration)contextConfigBase.rootConfig);
            return ctx;
        }
        catch (NullPointerException npe) {
            String errorMsg = "Error while creating ISecurityContext chain.";
            PortalSecurityException ep = new PortalSecurityException(errorMsg, (Throwable)npe);
            log.error((Object)ep, (Throwable)ep);
            throw ep;
        }
    }

    private static ISecurityContext createSecurityContextChain(ContextConfiguration contextConfig) throws PortalSecurityException {
        ISecurityContext securityContext = contextConfig.contextFactory.getSecurityContext();
        if (securityContext instanceof IConfigurableSecurityContext) {
            ((IConfigurableSecurityContext)securityContext).setProperties((Properties)contextConfig.contextProperties.clone());
        }
        for (int index = 0; index < contextConfig.subConfigs.length; ++index) {
            ISecurityContext subSecurityContext = InitialSecurityContextFactory.createSecurityContextChain((ContextConfiguration)contextConfig.subConfigs[index]);
            securityContext.addSubContext(contextConfig.subConfigs[index].contextName, subSecurityContext);
        }
        return securityContext;
    }

    private static ContextConfiguration loadContextConfigurationChain(String fullContextName, Properties securtiyProperties) throws PortalSecurityException {
        String factoryName = securtiyProperties.getProperty(fullContextName);
        if (factoryName == null) {
            PortalSecurityException ep = new PortalSecurityException("No such security context " + fullContextName);
            log.error((Object)ep.getMessage(), (Throwable)ep);
            throw ep;
        }
        ContextConfiguration contextConfig = new ContextConfiguration();
        int lastDotIndex = fullContextName.lastIndexOf(".");
        String localContextName = fullContextName;
        if (lastDotIndex >= 0) {
            try {
                localContextName = fullContextName.substring(lastDotIndex + 1);
            }
            catch (IndexOutOfBoundsException ioobe) {
                PortalSecurityException pse = new PortalSecurityException("Invalid context name " + fullContextName, (Throwable)ioobe);
                log.error((Object)pse.getMessage(), (Throwable)pse);
                throw pse;
            }
        }
        try {
            ISecurityContextFactory factory;
            contextConfig.contextFactory = factory = (ISecurityContextFactory)Class.forName(factoryName).newInstance();
            contextConfig.contextName = localContextName;
        }
        catch (Exception e) {
            PortalSecurityException ep = new PortalSecurityException("Failed to instantiate " + factoryName);
            log.error((Object)("Failed to instantiate " + factoryName), (Throwable)e);
            throw ep;
        }
        String contextConfigPropertyPrefix = "securityContextProperty." + fullContextName;
        Vector<ContextConfiguration> subContexts = new Vector<ContextConfiguration>();
        Enumeration<?> ctxnames = securtiyProperties.propertyNames();
        while (ctxnames.hasMoreElements()) {
            String securityPropName = (String)ctxnames.nextElement();
            if (securityPropName.startsWith(fullContextName) && securityPropName.length() > fullContextName.length() && securityPropName.indexOf(".", fullContextName.length() + 1) < 0) {
                ContextConfiguration subContextConfig = InitialSecurityContextFactory.loadContextConfigurationChain((String)securityPropName, (Properties)securtiyProperties);
                subContexts.add(subContextConfig);
                continue;
            }
            if (!securityPropName.startsWith(contextConfigPropertyPrefix) || securityPropName.length() <= contextConfigPropertyPrefix.length() || securityPropName.indexOf(".", contextConfigPropertyPrefix.length() + 1) >= 0) continue;
            String propValue = securtiyProperties.getProperty(securityPropName);
            String propName = securityPropName.substring(contextConfigPropertyPrefix.length() + 1);
            contextConfig.contextProperties.setProperty(propName, propValue);
        }
        contextConfig.subConfigs = subContexts.toArray(new ContextConfiguration[subContexts.size()]);
        return contextConfig;
    }
}

