/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.security;

import org.jasig.portal.security.IPortalPasswordService;
import org.jasypt.digest.config.DigesterConfig;
import org.jasypt.digest.config.SimpleDigesterConfig;
import org.jasypt.util.password.ConfigurablePasswordEncryptor;
import org.springframework.stereotype.Component;

@Component(value="portalPasswordService")
public class PortalPasswordServiceImpl
implements IPortalPasswordService {
    protected static final String MD5_PREFIX = "(MD5)";
    protected static final String SHA256_PREFIX = "(SHA256)";
    private ConfigurablePasswordEncryptor md5Encryptor = new ConfigurablePasswordEncryptor();
    private ConfigurablePasswordEncryptor sha256Encryptor;

    public PortalPasswordServiceImpl() {
        SimpleDigesterConfig md5Config = new SimpleDigesterConfig();
        md5Config.setIterations(Integer.valueOf(1));
        md5Config.setAlgorithm("MD5");
        md5Config.setSaltSizeBytes(Integer.valueOf(8));
        this.md5Encryptor.setConfig((DigesterConfig)md5Config);
        this.sha256Encryptor = new ConfigurablePasswordEncryptor();
        SimpleDigesterConfig shaConfig = new SimpleDigesterConfig();
        shaConfig.setIterations(Integer.valueOf(1000));
        shaConfig.setAlgorithm("SHA-256");
        shaConfig.setSaltSizeBytes(Integer.valueOf(8));
        this.sha256Encryptor.setConfig((DigesterConfig)shaConfig);
    }

    public String encryptPassword(String cleartext) {
        String encrypted = this.sha256Encryptor.encryptPassword(cleartext);
        if (encrypted.endsWith("\n")) {
            encrypted = encrypted.substring(0, encrypted.length() - 1);
        }
        encrypted = SHA256_PREFIX.concat(encrypted);
        return encrypted;
    }

    public boolean validatePassword(String cleartext, String encrypted) {
        if (encrypted.startsWith(MD5_PREFIX)) {
            encrypted = encrypted.substring(5);
            return this.md5Encryptor.checkPassword(cleartext, encrypted);
        }
        if (encrypted.startsWith(SHA256_PREFIX)) {
            encrypted = encrypted.substring(8);
            return this.sha256Encryptor.checkPassword(cleartext, encrypted);
        }
        throw new IllegalArgumentException("This portal password service is only currently capable of validating MD5 and SHA-256 passwords");
    }
}

