/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.security.mvc;

import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.PortalException;
import org.jasig.portal.events.IPortalAuthEventFactory;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.security.IPersonManager;
import org.jasig.portal.security.ISecurityContext;
import org.jasig.portal.security.IdentitySwapperManager;
import org.jasig.portal.utils.ResourceLoader;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/Logout"})
public class LogoutController
implements InitializingBean {
    private static final Log log = LogFactory.getLog(LogoutController.class);
    private Map<String, String> redirectMap;
    private IPortalAuthEventFactory portalEventFactory;
    private IPersonManager personManager;
    private IdentitySwapperManager identitySwapperManager;

    @Autowired
    public void setIdentitySwapperManager(IdentitySwapperManager identitySwapperManager) {
        this.identitySwapperManager = identitySwapperManager;
    }

    @Autowired
    public void setPersonManager(IPersonManager personManager) {
        this.personManager = personManager;
    }

    @Autowired
    public void setPortalEventFactory(IPortalAuthEventFactory portalEventFactory) {
        this.portalEventFactory = portalEventFactory;
    }

    public void afterPropertiesSet() throws Exception {
        HashMap<String, String> rdHash = new HashMap<String, String>(1);
        try {
            Properties props = ResourceLoader.getResourceAsProperties(LogoutController.class, (String)"/properties/security.properties");
            Enumeration<?> propNames = props.propertyNames();
            while (propNames.hasMoreElements()) {
                String propName = (String)propNames.nextElement();
                String propValue = props.getProperty(propName);
                if (!propName.startsWith("logoutRedirect.")) continue;
                String key = propName.substring(15);
                String string = key = key.startsWith("root.") ? key.substring(5) : key;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Redirect key=" + key + ", value=" + propValue));
                }
                rdHash.put(key, propValue);
            }
        }
        catch (PortalException pe) {
            log.error((Object)"Failed to load logout redirect URLs", (Throwable)pe);
        }
        catch (IOException ioe) {
            log.error((Object)"Failed to load logout redirect URLs", (Throwable)ioe);
        }
        this.redirectMap = rdHash;
    }

    @RequestMapping
    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String redirect;
        block8: {
            redirect = this.getRedirectionUrl(request);
            HttpSession session = request.getSession(false);
            if (session != null) {
                try {
                    IPerson person = this.personManager.getPerson(request);
                    if (person != null && person.getSecurityContext().isAuthenticated()) {
                        this.portalEventFactory.publishLogoutEvent(request, (Object)this, person);
                    }
                }
                catch (Exception e) {
                    log.error((Object)("Exception recording logout associated with request " + request), (Throwable)e);
                }
                String originalUid = this.identitySwapperManager.getOriginalUsername(session);
                if (originalUid != null) {
                    redirect = request.getContextPath() + "/Login";
                } else {
                    try {
                        session.invalidate();
                    }
                    catch (IllegalStateException ise) {
                        if (!log.isTraceEnabled()) break block8;
                        log.trace((Object)"LogoutController encountered IllegalStateException invalidating a presumably already-invalidated session.", (Throwable)ise);
                    }
                }
            }
        }
        String encodedRedirectURL = response.encodeRedirectURL(redirect);
        response.sendRedirect(encodedRedirectURL);
    }

    private String getRedirectionUrl(HttpServletRequest request) {
        String defaultRedirect;
        String redirect;
        block13: {
            redirect = null;
            defaultRedirect = request.getContextPath() + "/";
            IPerson person = null;
            if (this.redirectMap == null) {
                return defaultRedirect;
            }
            try {
                person = this.personManager.getPerson(request);
                if (person == null) break block13;
                ISecurityContext securityContext = person.getSecurityContext();
                if (securityContext.isAuthenticated()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"LogoutController::getRedirectionUrl() Looking for redirect string for the root context");
                    }
                    if ((redirect = (String)this.redirectMap.get("root")) != null && !redirect.equals("")) {
                        return redirect;
                    }
                }
                Enumeration subCtxNames = securityContext.getSubContextNames();
                while (subCtxNames.hasMoreElements()) {
                    String subCtxName = (String)subCtxNames.nextElement();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("LogoutController::getRedirectionUrl()  subCtxName = " + subCtxName));
                    }
                    ISecurityContext sc = securityContext.getSubContext(subCtxName);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("LogoutController::getRedirectionUrl() subCtxName isAuth = " + sc.isAuthenticated()));
                    }
                    if (!sc.isAuthenticated()) continue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("LogoutController::getRedirectionUrl() Looking for redirect string for subCtxName = " + subCtxName));
                    }
                    if ((redirect = (String)this.redirectMap.get(subCtxName)) == null || redirect.equals("")) continue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("LogoutController::getRedirectionUrl() subCtxName redirect = " + redirect));
                    }
                    break;
                }
            }
            catch (Exception e) {
                log.error((Object)"LogoutController::getRedirectionUrl() Error:", (Throwable)e);
            }
        }
        if (redirect == null) {
            redirect = defaultRedirect;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("LogoutController::getRedirectionUrl() redirectionURL = " + redirect));
        }
        return redirect;
    }
}

