/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.security.provider;

import java.util.Vector;
import org.jasig.portal.AuthorizationException;
import org.jasig.portal.portlet.om.PortletLifecycleState;
import org.jasig.portal.security.IAuthorizationPrincipal;
import org.jasig.portal.security.IAuthorizationService;
import org.jasig.portal.security.IPermission;
import org.jasig.portal.security.IPermissionPolicy;

public class AuthorizationPrincipalImpl
implements IAuthorizationPrincipal {
    private final String key;
    private final Class type;
    private IAuthorizationService authorizationService;
    private String principalString;

    public AuthorizationPrincipalImpl(String newKey, Class newType) {
        this(newKey, newType, null);
    }

    public AuthorizationPrincipalImpl(String newKey, Class newType, IAuthorizationService authService) {
        this.key = newKey;
        this.type = newType;
        this.authorizationService = authService;
        this.initialize();
    }

    public boolean canManage(String channelPublishId) throws AuthorizationException {
        return this.getAuthorizationService().canPrincipalManage((IAuthorizationPrincipal)this, channelPublishId);
    }

    public boolean canManage(PortletLifecycleState state, String categoryId) throws AuthorizationException {
        return this.getAuthorizationService().canPrincipalManage((IAuthorizationPrincipal)this, state, categoryId);
    }

    public boolean canConfigure(String channelPublishId) throws AuthorizationException {
        return this.getAuthorizationService().canPrincipalConfigure((IAuthorizationPrincipal)this, channelPublishId);
    }

    public boolean canRender(String channelPublishId) throws AuthorizationException {
        return this.getAuthorizationService().canPrincipalRender((IAuthorizationPrincipal)this, channelPublishId);
    }

    public boolean canSubscribe(String channelPublishId) throws AuthorizationException {
        return this.getAuthorizationService().canPrincipalSubscribe((IAuthorizationPrincipal)this, channelPublishId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IAuthorizationPrincipal)) {
            return false;
        }
        IAuthorizationPrincipal other = (IAuthorizationPrincipal)obj;
        if (this.key == null ? other.getKey() != null : !this.key.equals(other.getKey())) {
            return false;
        }
        return !(this.type == null ? other.getType() != null : !this.type.equals(other.getType()));
    }

    public IPermission[] getAllPermissions() throws AuthorizationException {
        return this.getAllPermissions(null, null, null);
    }

    public IPermission[] getAllPermissions(String owner, String activity, String target) throws AuthorizationException {
        return this.getAuthorizationService().getAllPermissionsForPrincipal((IAuthorizationPrincipal)this, owner, activity, target);
    }

    IAuthorizationService getAuthorizationService() {
        return this.authorizationService;
    }

    public Vector getAuthorizedChannels() throws AuthorizationException {
        return this.getAuthorizationService().getAuthorizedChannels((IAuthorizationPrincipal)this);
    }

    public String getKey() {
        return this.key;
    }

    public IPermission[] getPermissions() throws AuthorizationException {
        return this.getPermissions(null, null, null);
    }

    public IPermission[] getPermissions(String owner, String activity, String target) throws AuthorizationException {
        return this.getAuthorizationService().getPermissionsForPrincipal((IAuthorizationPrincipal)this, owner, activity, target);
    }

    public String getPrincipalString() {
        return this.principalString;
    }

    public Class getType() {
        return this.type;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean hasPermission(String owner, String activity, String target) throws AuthorizationException {
        return this.getAuthorizationService().doesPrincipalHavePermission((IAuthorizationPrincipal)this, owner, activity, target);
    }

    private void initialize() {
        this.principalString = this.getAuthorizationService().getPrincipalString((IAuthorizationPrincipal)this);
    }

    void setAuthorizationService(IAuthorizationService newAuthorizationService) {
        this.authorizationService = newAuthorizationService;
    }

    public String toString() {
        return this.getPrincipalString();
    }

    public boolean hasPermission(String owner, String activity, String target, IPermissionPolicy policy) throws AuthorizationException {
        return this.getAuthorizationService().doesPrincipalHavePermission((IAuthorizationPrincipal)this, owner, activity, target, policy);
    }
}

