/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.security.provider;

import java.util.Comparator;
import java.util.Enumeration;
import java.util.Vector;
import org.jasig.portal.properties.PropertiesManager;
import org.jasig.portal.security.IAdditionalDescriptor;
import org.jasig.portal.security.IOpaqueCredentials;
import org.jasig.portal.security.IParentAwareSecurityContext;
import org.jasig.portal.security.IPrincipal;
import org.jasig.portal.security.ISecurityContext;
import org.jasig.portal.security.PortalSecurityException;
import org.jasig.portal.security.provider.ChainingSecurityContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ChainingSecurityContext
implements ISecurityContext {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final boolean DEFAULT_STOP_WHEN_AUTHENTICATED = true;
    protected static boolean stopWhenAuthenticated = PropertiesManager.getPropertyAsBoolean((String)"org.jasig.portal.security.provider.ChainingSecurityContext.stopWhenAuthenticated", (boolean)true);
    protected boolean isauth = false;
    protected Vector mySubContexts;
    protected ChainingPrincipal myPrincipal = new ChainingPrincipal(this);
    protected ChainingOpaqueCredentials myOpaqueCredentials = new ChainingOpaqueCredentials(this);
    protected IAdditionalDescriptor myAdditionalDescriptor = new ChainingAdditionalDescriptor(this);
    protected Comparator myOrder;

    public ChainingSecurityContext() {
        this.mySubContexts = new Vector();
    }

    public IPrincipal getPrincipalInstance() {
        if (this.isauth) {
            return new ChainingPrincipal(this);
        }
        return this.myPrincipal;
    }

    public IOpaqueCredentials getOpaqueCredentialsInstance() {
        if (this.isauth) {
            return new ChainingOpaqueCredentials(this);
        }
        return this.myOpaqueCredentials;
    }

    public synchronized void authenticate() throws PortalSecurityException {
        Enumeration e = this.mySubContexts.elements();
        boolean error = false;
        while (e.hasMoreElements()) {
            ISecurityContext sctx = ((Entry)e.nextElement()).getCtx();
            try {
                if (sctx instanceof IParentAwareSecurityContext) {
                    ((IParentAwareSecurityContext)sctx).authenticate((ISecurityContext)this);
                } else {
                    sctx.authenticate();
                }
            }
            catch (Exception ex) {
                error = true;
                this.log.error("Exception authenticating subcontext " + sctx, (Throwable)ex);
            }
            if (!stopWhenAuthenticated || !sctx.isAuthenticated()) continue;
            break;
        }
        if (this.myOpaqueCredentials.credentialstring != null) {
            for (int i = 0; i < this.myOpaqueCredentials.credentialstring.length; ++i) {
                this.myOpaqueCredentials.credentialstring[i] = 0;
            }
            this.myOpaqueCredentials.credentialstring = null;
        }
        if (error && !this.isauth) {
            throw new PortalSecurityException("One of the security subcontexts threw an exception");
        }
    }

    public IPrincipal getPrincipal() {
        if (this.isauth) {
            return this.myPrincipal;
        }
        return null;
    }

    public IOpaqueCredentials getOpaqueCredentials() {
        if (this.isauth) {
            return this.myOpaqueCredentials;
        }
        return null;
    }

    public IAdditionalDescriptor getAdditionalDescriptor() {
        if (this.isauth) {
            return this.myAdditionalDescriptor;
        }
        return null;
    }

    public boolean isAuthenticated() {
        return this.isauth;
    }

    public synchronized ISecurityContext getSubContext(String name) {
        for (int i = 0; i < this.mySubContexts.size(); ++i) {
            Entry entry = (Entry)this.mySubContexts.get(i);
            if (entry.getKey() == null || !entry.getKey().equals(name)) continue;
            return entry.getCtx();
        }
        PortalSecurityException ep = new PortalSecurityException("No such subcontext: " + name);
        if (this.log.isDebugEnabled()) {
            this.log.debug("No such subcontext as " + name, (Throwable)ep);
        }
        return null;
    }

    public synchronized boolean doesSubContextExist(String name) {
        for (int i = 0; i < this.mySubContexts.size(); ++i) {
            Entry entry = (Entry)this.mySubContexts.get(i);
            if (entry.getKey() == null || !entry.getKey().equals(name)) continue;
            return true;
        }
        return false;
    }

    public synchronized Enumeration getSubContexts() {
        Enumeration e = this.mySubContexts.elements();
        return new Adapter(this, e);
    }

    public synchronized void addSubContext(String name, ISecurityContext ctx) throws PortalSecurityException {
        if (this.doesSubContextExist(name)) {
            PortalSecurityException ep = new PortalSecurityException("Subcontext already exists: " + name);
            this.log.error("Subcontext already exists:" + name, (Throwable)ep);
            throw ep;
        }
        this.mySubContexts.add(new Entry(name, ctx));
    }

    public synchronized Enumeration getSubContextNames() {
        Vector<String> scNames = new Vector<String>();
        for (int i = 0; i < this.mySubContexts.size(); ++i) {
            Entry entry = (Entry)this.mySubContexts.get(i);
            if (entry.getKey() == null) continue;
            scNames.add(entry.getKey());
        }
        return scNames.elements();
    }
}

