/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.security.provider;

import org.jasig.portal.AuthorizationException;
import org.jasig.portal.security.IAuthorizationPrincipal;
import org.jasig.portal.security.IPermission;
import org.jasig.portal.security.IPermissionManager;
import org.jasig.portal.security.IPermissionStore;
import org.jasig.portal.security.provider.AuthorizationImpl;

public class PermissionManagerImpl
implements IPermissionManager {
    private AuthorizationImpl authorizationService;
    protected static IPermissionStore permissionStore;
    private String owner;

    public PermissionManagerImpl(String newOwner, AuthorizationImpl authService) {
        this.owner = newOwner;
        this.authorizationService = authService;
    }

    public IPermission[] getAllPermissions(IAuthorizationPrincipal principal, String activity, String target) throws AuthorizationException {
        return principal.getAllPermissions(this.getOwner(), activity, target);
    }

    AuthorizationImpl getAuthorizationService() {
        return this.authorizationService;
    }

    public IAuthorizationPrincipal[] getAuthorizedPrincipals(String activity, String target) throws AuthorizationException {
        return this.getAuthorizationService().getAuthorizedPrincipals(this.getOwner(), activity, target);
    }

    public String getOwner() {
        return this.owner;
    }

    public IPermission[] getPermissions(String activity, String target) throws AuthorizationException {
        return this.getAuthorizationService().getPermissionsForOwner(this.getOwner(), activity, target);
    }

    public IPermission[] getPermissions(IAuthorizationPrincipal principal, String activity, String target) throws AuthorizationException {
        return principal.getPermissions(this.getOwner(), activity, target);
    }
}

