/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.security.provider;

import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.jasig.portal.EntityIdentifier;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.security.ISecurityContext;
import org.jasig.portal.security.PersonFactory;

public class PersonImpl
implements IPerson {
    private static final long serialVersionUID = 1L;
    protected ConcurrentMap<String, List<Object>> userAttributes = null;
    protected String m_FullName = null;
    protected int m_ID = -1;
    protected ISecurityContext m_securityContext = null;
    protected EntityIdentifier m_eid = new EntityIdentifier(null, IPerson.class);
    protected boolean entityIdentifierSet = false;

    public ISecurityContext getSecurityContext() {
        return this.m_securityContext;
    }

    public void setSecurityContext(ISecurityContext securityContext) {
        this.m_securityContext = securityContext;
    }

    public Object getAttribute(String key) {
        if (this.userAttributes == null) {
            return null;
        }
        List values = (List)this.userAttributes.get(key);
        if (values != null && values.size() > 0) {
            return values.get(0);
        }
        return null;
    }

    public Object[] getAttributeValues(String key) {
        if (this.userAttributes == null) {
            return null;
        }
        List values = (List)this.userAttributes.get(key);
        if (values != null) {
            return values.toArray();
        }
        return null;
    }

    public Enumeration<List<Object>> getAttributes() {
        if (this.userAttributes == null) {
            return null;
        }
        Collection values = this.userAttributes.values();
        return Collections.enumeration(values);
    }

    public Map<String, List<Object>> getAttributeMap() {
        ConcurrentMap attrMap = this.userAttributes;
        return attrMap;
    }

    public Enumeration<String> getAttributeNames() {
        if (this.userAttributes == null) {
            return null;
        }
        Set names = this.userAttributes.keySet();
        return Collections.enumeration(names);
    }

    public void setAttribute(String key, Object value) {
        if (value == null) {
            this.setAttribute(key, (List)null);
        } else {
            this.setAttribute(key, Collections.singletonList(value));
        }
    }

    public void setAttribute(String key, List<Object> value) {
        if (this.userAttributes == null) {
            this.userAttributes = new ConcurrentHashMap();
        }
        if (value != null) {
            this.userAttributes.put(key, value);
        } else {
            this.userAttributes.remove(key);
        }
        if (!this.entityIdentifierSet && key.equals("username")) {
            Object userName = value != null && value.size() > 0 ? value.get(0) : null;
            this.m_eid = new EntityIdentifier(String.valueOf(userName), IPerson.class);
        }
    }

    public void setAttributes(Map<String, List<Object>> attrs) {
        for (Map.Entry<String, List<Object>> attrEntry : attrs.entrySet()) {
            String key = attrEntry.getKey();
            List<Object> value = attrEntry.getValue();
            this.setAttribute(key, value);
        }
    }

    public int getID() {
        return this.m_ID;
    }

    public void setID(int sID) {
        this.m_ID = sID;
    }

    public String getUserName() {
        return (String)this.getAttribute("username");
    }

    public void setUserName(String userName) {
        this.setAttribute("username", (Object)userName);
    }

    public String getFullName() {
        return this.m_FullName;
    }

    public void setFullName(String sFullName) {
        this.m_FullName = sFullName;
    }

    public boolean isGuest() {
        boolean isGuest = false;
        String userName = (String)this.getAttribute("username");
        if (PersonFactory.GUEST_USERNAME.equalsIgnoreCase(userName) && (this.m_securityContext == null || !this.m_securityContext.isAuthenticated())) {
            isGuest = true;
        }
        return isGuest;
    }

    public EntityIdentifier getEntityIdentifier() {
        return this.m_eid;
    }

    public void setEntityIdentifier(EntityIdentifier ei) {
        this.m_eid = ei;
        this.entityIdentifierSet = true;
    }

    public String getName() {
        return (String)this.getAttribute("username");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(PersonImpl.class.getName());
        sb.append(" fullName=[");
        sb.append(this.m_FullName);
        sb.append("]");
        sb.append(" id=[");
        sb.append(this.m_ID);
        sb.append("]");
        sb.append(" securityContext=[");
        sb.append(this.m_securityContext);
        sb.append("]");
        sb.append(" attributes=[");
        sb.append(this.userAttributes);
        sb.append("]");
        sb.append(" isGuest:");
        sb.append(this.isGuest());
        return sb.toString();
    }

    public int hashCode() {
        int result = new HashCodeBuilder(209348721, -93847839).append(this.m_ID).toHashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof IPerson)) {
            return false;
        }
        IPerson other = (IPerson)obj;
        return new EqualsBuilder().append(this.getID(), other.getID()).isEquals();
    }
}

