/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.security.provider;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.security.ISecurityContext;
import org.jasig.portal.security.PortalSecurityException;
import org.jasig.portal.security.provider.ChainingSecurityContext;

class RemoteUserSecurityContext
extends ChainingSecurityContext
implements ISecurityContext {
    private static final Log log = LogFactory.getLog(RemoteUserSecurityContext.class);
    private static final int REMOTEUSERSECURITYAUTHTYPE = 65329;
    private String remoteUser;

    RemoteUserSecurityContext() {
        this(null);
    }

    RemoteUserSecurityContext(String user) {
        this.remoteUser = user;
    }

    public int getAuthType() {
        return 65329;
    }

    public synchronized void authenticate() throws PortalSecurityException {
        if (this.remoteUser != null) {
            this.myPrincipal.setUID(this.remoteUser);
            String newUid = this.myPrincipal.getUID();
            if (this.remoteUser.equals(newUid)) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Authentication REMOTE_USER(" + this.remoteUser + ")."));
                }
                this.isauth = true;
            } else if (log.isInfoEnabled()) {
                log.info((Object)("Authentication failed. REMOTE_USER(" + this.remoteUser + ") != user(" + newUid + ")."));
            }
        } else if (log.isInfoEnabled()) {
            log.info((Object)("Authentication failed. REMOTE_USER not set for(" + this.myPrincipal.getUID() + ")."));
        }
        super.authenticate();
    }

    public void setRemoteUser(String remoteUser) {
        this.remoteUser = remoteUser;
    }
}

