/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.security.provider.cas.clearpass;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.jasig.cas.client.util.CommonUtils;
import org.jasig.cas.client.util.XmlUtils;
import org.jasig.cas.client.validation.Assertion;
import org.jasig.portal.properties.PropertiesManager;
import org.jasig.portal.security.IOpaqueCredentials;
import org.jasig.portal.security.provider.cas.CasAssertionSecurityContext;
import org.jasig.portal.security.provider.cas.clearpass.PasswordCachingCasAssertionSecurityContext;
import org.springframework.util.Assert;

public class PasswordCachingCasAssertionSecurityContext
extends CasAssertionSecurityContext {
    private static final ScheduledExecutorService executor = Executors.newScheduledThreadPool(5);
    private static final int MAX_PASSWORD_RETRIEVAL_RETRY_ATTEMPTS = 5;
    private static final long PASSWORD_RETRIEVAL_DELAY = 300L;
    private static final String PROPERTY_PASSWORD_RETRIEVAL_DELAY = "org.jasig.portal.security.provider.cas.clearpass.retryDelay";
    private static final String PROPERTY_PASSWORD_RETRIEVAL_MAX_RETRY_ATTEMPTS = "org.jasig.portal.security.provider.cas.clearpass.maxRetryAttempts";
    private static final long serialVersionUID = -3816036745827152340L;
    private final String clearPassUrl;
    private byte[] cachedCredentials;
    private Assertion assertion;
    private String proxyTicket;
    private int passwordRetrievalCount;
    private long passwordRetrievalDelay;
    private int passwordRetrievalMaxRetryAttempts;

    protected PasswordCachingCasAssertionSecurityContext(String clearPassUrl) {
        Assert.notNull((Object)clearPassUrl, (String)"clearPassUrl cannot be null.");
        this.clearPassUrl = clearPassUrl;
        this.passwordRetrievalDelay = PropertiesManager.getPropertyAsLong((String)PROPERTY_PASSWORD_RETRIEVAL_DELAY, (long)300L);
        this.passwordRetrievalMaxRetryAttempts = PropertiesManager.getPropertyAsInt((String)PROPERTY_PASSWORD_RETRIEVAL_MAX_RETRY_ATTEMPTS, (int)5);
    }

    protected final void postAuthenticate(Assertion assertion) {
        this.assertion = assertion;
        this.retrievePasswordFromCasServer();
    }

    public final IOpaqueCredentials getOpaqueCredentials() {
        byte[] password = this.retrievePasswordFromCasServer();
        if (password == null) {
            return super.getOpaqueCredentials();
        }
        CacheOpaqueCredentials credentials = new CacheOpaqueCredentials(this, null);
        credentials.setCredentials(password);
        return credentials;
    }

    protected synchronized byte[] retrievePasswordFromCasServer() {
        if (this.cachedCredentials == null) {
            if (this.proxyTicket == null) {
                this.log.debug("Attempting to get CAS ClearPass Proxy Ticket for user {} using PGTIOU in assertion", (Object)this.assertion.getPrincipal().getName());
                this.proxyTicket = this.assertion.getPrincipal().getProxyTicketFor(this.clearPassUrl);
            }
            if (this.proxyTicket != null) {
                this.log.debug("Attempting to get password for user {} using Proxy Ticket {}", (Object)this.assertion.getPrincipal().getName(), (Object)this.proxyTicket);
                String password = this.retrievePasswordUsingProxyTicket(this.proxyTicket);
                if (password != null) {
                    this.log.debug("Password retrieved from ClearPass.");
                    this.cachedCredentials = password.getBytes();
                }
            }
            if (this.cachedCredentials == null) {
                String message;
                String string = message = this.proxyTicket == null ? "proxy ticket" : "password";
                if (++this.passwordRetrievalCount > this.passwordRetrievalMaxRetryAttempts) {
                    this.log.error("Unable to obtain {} for {} from CAS ClearPass in {} attempts. Check your uPortal and CAS configuration.  See uPortal manual section on Caching and Replaying credentials", new Object[]{message, this.assertion.getPrincipal().getName(), this.passwordRetrievalCount});
                } else {
                    this.log.info("Unable to obtain {} for {} from CAS ClearPass. Will try again {} more times {}", new Object[]{message, this.assertion.getPrincipal().getName(), this.passwordRetrievalMaxRetryAttempts - this.passwordRetrievalCount + 1, this.proxyTicket == null ? " for PGT to replicate to this server through distributed cache" : ""});
                    executor.schedule((Runnable)new ObtainPasswordWorker(this, this), this.passwordRetrievalDelay, TimeUnit.MILLISECONDS);
                }
            }
        }
        return this.cachedCredentials;
    }

    private synchronized byte[] getCachedCredentials() {
        return this.cachedCredentials;
    }

    protected final String retrievePasswordUsingProxyTicket(String proxyTicket) {
        try {
            String url = this.clearPassUrl + (this.clearPassUrl.contains("?") ? "&" : "?") + "ticket=" + proxyTicket;
            String response = this.retrieveResponseFromServer(url, "UTF-8");
            String password = XmlUtils.getTextForElement((String)response, (String)"credentials");
            if (CommonUtils.isNotBlank((String)password)) {
                return password;
            }
            this.log.error("Unable to Retrieve Password using url {}.  If you see a [403] HTTP response code returned from CommonUtils then it most likely means the proxy configuration on the CAS server is not correct.\n\nFull Response from ClearPass was [{}]", (Object)url, (Object)response);
            return null;
        }
        catch (Exception e) {
            if (this.log.isWarnEnabled()) {
                this.log.warn("Unable to retrieve the credential from the ClearPass service for proxy ticket {}", (Object)proxyTicket, (Object)e);
            }
            return null;
        }
    }

    protected String retrieveResponseFromServer(String url, String encoding) {
        return CommonUtils.getResponseFromServer((String)url, (String)"UTF-8");
    }
}

