/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.security.provider.cas.clearpass;

import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.jasig.cas.client.util.CommonUtils;
import org.jasig.portal.security.ISecurityContext;
import org.jasig.portal.security.ISecurityContextFactory;
import org.jasig.portal.security.provider.cas.clearpass.PasswordCachingCasAssertionSecurityContext;
import org.springframework.core.io.ClassPathResource;

public final class PasswordCachingCasAssertionSecurityContextFactory
implements ISecurityContextFactory {
    private static final String DEFAULT_PORTAL_SECURITY_PROPERTY_FILE = "properties/security.properties";
    private static final String CLEARPASS_CAS_URL_PROPERTY = PasswordCachingCasAssertionSecurityContextFactory.class.getName() + ".clearPassCasUrl";
    private final String clearPassUrl;

    public PasswordCachingCasAssertionSecurityContextFactory() {
        ClassPathResource resource = new ClassPathResource(DEFAULT_PORTAL_SECURITY_PROPERTY_FILE, this.getClass().getClassLoader());
        Properties securityProperties = new Properties();
        InputStream inputStream = null;
        try {
            inputStream = resource.getInputStream();
            securityProperties.load(inputStream);
            this.clearPassUrl = securityProperties.getProperty(CLEARPASS_CAS_URL_PROPERTY);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    public ISecurityContext getSecurityContext() {
        if (CommonUtils.isNotBlank((String)this.clearPassUrl)) {
            return new PasswordCachingCasAssertionSecurityContext(this.clearPassUrl);
        }
        throw new IllegalStateException(String.format("clearPassUrl not configured.  Cannot create an instance of [%s] without it.", this.getClass().getSimpleName()));
    }
}

