/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.security.remoting;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.groups.IEntityGroup;
import org.jasig.portal.groups.IGroupMember;
import org.jasig.portal.layout.dlm.remoting.IGroupListHelper;
import org.jasig.portal.layout.dlm.remoting.JsonEntityBean;
import org.jasig.portal.portlets.groupselector.EntityEnum;
import org.jasig.portal.portlets.permissionsadmin.Assignment;
import org.jasig.portal.portlets.permissionsadmin.IPermissionAdministrationHelper;
import org.jasig.portal.security.IAuthorizationPrincipal;
import org.jasig.portal.security.IAuthorizationService;
import org.jasig.portal.security.IPermission;
import org.jasig.portal.security.IPermissionStore;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.security.IPersonManager;
import org.jasig.portal.security.provider.PermissionImpl;
import org.jasig.portal.security.remoting.AbstractPermissionsController;
import org.jasig.portal.services.AuthorizationService;
import org.jasig.portal.services.GroupService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PermissionAssignmentMapController
extends AbstractPermissionsController {
    protected final Log log = LogFactory.getLog(this.getClass());
    private IGroupListHelper groupListHelper;
    private IPermissionAdministrationHelper permissionAdministrationHelper;
    private IPersonManager personManager;
    private IPermissionStore permissionStore;
    private IAuthorizationService authorizationService;

    @Autowired(required=true)
    public void setGroupListHelper(IGroupListHelper groupListHelper) {
        this.groupListHelper = groupListHelper;
    }

    @Autowired(required=true)
    public void setPermissionAdministrationHelper(IPermissionAdministrationHelper permissionAdministrationHelper) {
        this.permissionAdministrationHelper = permissionAdministrationHelper;
    }

    @Autowired(required=true)
    public void setPersonManager(IPersonManager personManager) {
        this.personManager = personManager;
    }

    @Autowired
    public void setPermissionStore(IPermissionStore permissionStore) {
        this.permissionStore = permissionStore;
    }

    @Autowired
    public void setAuthorizationService(IAuthorizationService authorizationService) {
        this.authorizationService = authorizationService;
    }

    @RequestMapping(value={"/updatePermission"}, method={RequestMethod.GET})
    public ModelAndView updatePermission(@RequestParam(value="principal") String principal, @RequestParam(value="assignment") String assignment, @RequestParam(value="principals[]") String[] principals, @RequestParam(value="owner") String owner, @RequestParam(value="activity") String activity, @RequestParam(value="target") String target, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IPerson currentUser = this.personManager.getPerson(request);
        if (!this.permissionAdministrationHelper.canEditPermission(currentUser, target) || !this.permissionAdministrationHelper.canViewPermission(currentUser, target)) {
            response.setStatus(401);
            return null;
        }
        JsonEntityBean bean = this.groupListHelper.getEntityForPrincipal(principal);
        if (bean != null) {
            IAuthorizationPrincipal p = this.groupListHelper.getPrincipalForEntity(bean);
            IPermission[] directPermissions = this.permissionStore.select(owner, p.getPrincipalString(), activity, target, null);
            this.authorizationService.removePermissions(directPermissions);
            assignment = assignment.toUpperCase();
            if (assignment.equals(Assignment.Type.GRANT.toString()) || assignment.equals(Assignment.Type.DENY.toString())) {
                PermissionImpl permission = new PermissionImpl(owner);
                permission.setActivity(activity);
                permission.setPrincipal(bean.getPrincipalString());
                permission.setTarget(target);
                permission.setType(assignment);
                this.authorizationService.addPermissions(new IPermission[]{permission});
            }
        } else {
            this.log.warn((Object)("Unable to resolve the following principal (will be omitted from the list of assignments):  " + principal));
        }
        return this.getOwners(principals, owner, activity, target, request, response);
    }

    @RequestMapping(value={"/permissionAssignmentMap"}, method={RequestMethod.GET})
    public ModelAndView getOwners(@RequestParam(value="principals[]") String[] principals, @RequestParam(value="owner") String owner, @RequestParam(value="activity") String activity, @RequestParam(value="target") String target, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IPerson currentUser = this.personManager.getPerson(request);
        if (!this.permissionAdministrationHelper.canViewPermission(currentUser, target)) {
            response.setStatus(401);
            return null;
        }
        ArrayList<Assignment> flatAssignmentsList = new ArrayList<Assignment>();
        for (String principal : principals) {
            JsonEntityBean bean = this.groupListHelper.getEntityForPrincipal(principal);
            if (bean != null) {
                IAuthorizationPrincipal p = this.groupListHelper.getPrincipalForEntity(bean);
                Assignment.Type type = this.getAssignmentType(p, owner, activity, target);
                flatAssignmentsList.add(new Assignment(principal, bean, type));
                continue;
            }
            this.log.warn((Object)("Unable to resolve the following principal (will be omitted from the list of assignments):  " + principal));
        }
        ArrayList assignments = new ArrayList();
        for (Assignment a : flatAssignmentsList) {
            this.placeInHierarchy(a, assignments, owner, activity, target);
        }
        Map model = Collections.singletonMap("assignments", assignments);
        return new ModelAndView("jsonView", model);
    }

    private void placeInHierarchy(Assignment a, List<Assignment> hierarchy, String owner, String activity, String target) {
        if (a == null) {
            String msg = "Argument 'a' [Assignment] cannot be null";
            throw new IllegalArgumentException(msg);
        }
        if (hierarchy == null) {
            String msg = "Argument 'hierarchy' cannot be null";
            throw new IllegalArgumentException(msg);
        }
        for (Assignment root : hierarchy) {
            Assignment duplicate = root.findDecendentOrSelfIfExists(a.getPrincipal());
            if (duplicate == null) continue;
            return;
        }
        Object member = null;
        EntityEnum entityEnum = a.getPrincipal().getEntityType();
        member = entityEnum.isGroup() ? GroupService.findGroup((String)a.getPrincipal().getId()) : GroupService.getGroupMember((String)a.getPrincipal().getId(), (Class)entityEnum.getClazz());
        AuthorizationService authService = AuthorizationService.instance();
        Iterator it = GroupService.getCompositeGroupService().findContainingGroups((IGroupMember)member);
        if (it.hasNext()) {
            while (it.hasNext()) {
                IEntityGroup group = (IEntityGroup)it.next();
                EntityEnum beanType = EntityEnum.getEntityEnum((Class)group.getEntityType(), (boolean)true);
                JsonEntityBean bean = new JsonEntityBean(group, beanType);
                Assignment parent = null;
                for (Assignment root : hierarchy) {
                    parent = root.findDecendentOrSelfIfExists(bean);
                    if (parent == null) continue;
                    parent.addChild(a);
                    break;
                }
                if (parent != null) continue;
                IAuthorizationPrincipal principal = authService.newPrincipal((IGroupMember)group);
                Assignment.Type assignmentType = this.getAssignmentType(principal, owner, activity, target);
                parent = new Assignment(principal.getPrincipalString(), bean, assignmentType);
                parent.addChild(a);
                this.placeInHierarchy(parent, hierarchy, owner, activity, target);
            }
        } else {
            hierarchy.add(a);
        }
    }

    private Assignment.Type getAssignmentType(IAuthorizationPrincipal principal, String owner, String activity, String target) {
        IPermission[] directPermissions = this.permissionStore.select(owner, principal.getPrincipalString(), activity, target, null);
        Assignment.Type type = directPermissions.length > 0 ? (directPermissions[0].getType().equals("GRANT") ? Assignment.Type.GRANT : Assignment.Type.DENY) : (principal.hasPermission(owner, activity, target) ? Assignment.Type.INHERIT_GRANT : Assignment.Type.INHERIT_DENY);
        return type;
    }
}

