/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.security.remoting;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.EntityTypes;
import org.jasig.portal.groups.IEntityGroup;
import org.jasig.portal.layout.dlm.remoting.IGroupListHelper;
import org.jasig.portal.layout.dlm.remoting.JsonEntityBean;
import org.jasig.portal.permission.IPermissionActivity;
import org.jasig.portal.permission.IPermissionOwner;
import org.jasig.portal.permission.dao.IPermissionOwnerDao;
import org.jasig.portal.permission.target.IPermissionTarget;
import org.jasig.portal.permission.target.IPermissionTargetProvider;
import org.jasig.portal.permission.target.IPermissionTargetProviderRegistry;
import org.jasig.portal.security.IPermission;
import org.jasig.portal.security.IPermissionStore;
import org.jasig.portal.security.remoting.AbstractPermissionsController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/permissionAssignments"})
public class PermissionsListController
extends AbstractPermissionsController {
    private static final String PRINCIPAL_SEPARATOR = "\\.";
    protected final Log log = LogFactory.getLog(this.getClass());
    private IGroupListHelper groupListHelper;
    private IPermissionOwnerDao permissionOwnerDao;
    private IPermissionTargetProviderRegistry targetProviderRegistry;
    private IPermissionStore permissionStore;

    @Autowired(required=true)
    public void setGroupListHelper(IGroupListHelper groupListHelper) {
        this.groupListHelper = groupListHelper;
    }

    @Autowired(required=true)
    public void setPermissionOwnerDao(IPermissionOwnerDao permissionOwnerDao) {
        this.permissionOwnerDao = permissionOwnerDao;
    }

    @Autowired(required=true)
    public void setPermissionTargetProviderRegistry(IPermissionTargetProviderRegistry targetProviderRegistry) {
        this.targetProviderRegistry = targetProviderRegistry;
    }

    @Autowired
    public void setPermissionStore(IPermissionStore permissionStore) {
        this.permissionStore = permissionStore;
    }

    @RequestMapping(method={RequestMethod.GET})
    public ModelAndView getAssignments(@RequestParam(value="owner", required=false) String ownerParam, @RequestParam(value="principal", required=false) String principalParam, @RequestParam(value="activity", required=false) String activityParam, @RequestParam(value="target", required=false) String targetParam, HttpServletRequest req, HttpServletResponse response) throws Exception {
        if (!this.isAuthorized(req)) {
            response.setStatus(401);
            return null;
        }
        IPermission[] rslt = this.permissionStore.select(ownerParam, principalParam, activityParam, targetParam, null);
        return new ModelAndView("jsonView", "permissionsList", (Object)this.marshall(rslt));
    }

    private List<Map<String, String>> marshall(IPermission[] data) {
        if (data == null) {
            String msg = "Argument 'data' cannot be null";
            throw new IllegalArgumentException(msg);
        }
        ArrayList<Map<String, String>> rslt = new ArrayList<Map<String, String>>(data.length);
        for (IPermission p : data) {
            JsonEntityBean bean = this.getEntityBean(p.getPrincipal());
            HashMap<String, String> entry = new HashMap<String, String>();
            entry.put("owner", p.getOwner());
            entry.put("principalType", bean.getEntityTypeAsString());
            entry.put("principalName", bean.getName());
            entry.put("principalKey", p.getPrincipal());
            entry.put("activity", p.getActivity());
            entry.put("target", p.getTarget());
            entry.put("permissionType", p.getType());
            String targetName = null;
            try {
                IPermissionActivity activity = this.permissionOwnerDao.getPermissionActivity(p.getOwner(), p.getActivity());
                entry.put("activityName", activity.getName());
                IPermissionOwner owner = this.permissionOwnerDao.getPermissionOwner(p.getOwner());
                entry.put("ownerName", owner.getName());
                String providerKey = activity.getTargetProviderKey();
                IPermissionTargetProvider provider = this.targetProviderRegistry.getTargetProvider(providerKey);
                IPermissionTarget target = provider.getTarget(p.getTarget());
                targetName = target.getName();
            }
            catch (RuntimeException e) {
                this.log.trace((Object)"Failed to resolve target name", (Throwable)e);
            }
            if (targetName == null) {
                targetName = p.getTarget();
            }
            entry.put("targetName", targetName);
            rslt.add(entry);
        }
        return rslt;
    }

    protected JsonEntityBean getEntityBean(String principalString) {
        String[] parts = principalString.split(PRINCIPAL_SEPARATOR, 2);
        String key = parts[1];
        int typeId = Integer.parseInt(parts[0]);
        Class type = EntityTypes.getEntityType((Integer)typeId);
        String entityType = "person";
        if (IEntityGroup.class.isAssignableFrom(type)) {
            entityType = "group";
        }
        JsonEntityBean bean = this.groupListHelper.getEntity(entityType, key, false);
        return bean;
    }
}

