/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.services;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.AuthorizationException;
import org.jasig.portal.IUserIdentityStore;
import org.jasig.portal.events.IPortalAuthEventFactory;
import org.jasig.portal.properties.PropertiesManager;
import org.jasig.portal.security.IAdditionalDescriptor;
import org.jasig.portal.security.IOpaqueCredentials;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.security.IPrincipal;
import org.jasig.portal.security.ISecurityContext;
import org.jasig.portal.security.PortalSecurityException;
import org.jasig.portal.security.ThreadNamingRequestFilter;
import org.jasig.portal.security.provider.ChainingSecurityContext;
import org.jasig.portal.services.GroupService;
import org.jasig.portal.utils.MovingAverage;
import org.jasig.portal.utils.MovingAverageSample;
import org.jasig.portal.utils.cache.UsernameTaggedCacheEntryPurger;
import org.jasig.services.persondir.IPersonAttributeDao;
import org.jasig.services.persondir.IPersonAttributes;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class Authentication {
    private static final Log log = LogFactory.getLog(Authentication.class);
    private static final String BASE_CONTEXT_NAME = "root";
    private static final MovingAverage authenticationTimes = new MovingAverage();
    public static MovingAverageSample lastAuthentication = new MovingAverageSample();
    private ThreadNamingRequestFilter threadNamingRequestFilter;
    private IUserIdentityStore userIdentityStore;
    private IPortalAuthEventFactory portalEventFactory;
    private IPersonAttributeDao personAttributeDao;
    private UsernameTaggedCacheEntryPurger usernameTaggedCacheEntryPurger;

    @Autowired
    public void setUsernameTaggedCacheEntryPurger(UsernameTaggedCacheEntryPurger usernameTaggedCacheEntryPurger) {
        this.usernameTaggedCacheEntryPurger = usernameTaggedCacheEntryPurger;
    }

    @Autowired
    public void setThreadNamingRequestFilter(ThreadNamingRequestFilter threadNamingRequestFilter) {
        this.threadNamingRequestFilter = threadNamingRequestFilter;
    }

    @Autowired
    public void setPersonAttributeDao(@Qualifier(value="personAttributeDao") IPersonAttributeDao personAttributeDao) {
        this.personAttributeDao = personAttributeDao;
    }

    @Autowired
    public void setUserIdentityStore(IUserIdentityStore userIdentityStore) {
        this.userIdentityStore = userIdentityStore;
    }

    @Autowired
    public void setPortalEventFactory(IPortalAuthEventFactory portalEventFactory) {
        this.portalEventFactory = portalEventFactory;
    }

    public void authenticate(HttpServletRequest request, Map<String, String> principals, Map<String, String> credentials, IPerson person) throws PortalSecurityException {
        ISecurityContext securityContext = person.getSecurityContext();
        this.configureSecurityContextChain(principals, credentials, person, securityContext, BASE_CONTEXT_NAME);
        long start = System.currentTimeMillis();
        securityContext.authenticate();
        long elapsed = System.currentTimeMillis() - start;
        if (securityContext.isAuthenticated()) {
            boolean autocreate;
            String username;
            IPersonAttributes personAttributes;
            lastAuthentication = authenticationTimes.add(elapsed);
            String userName = securityContext.getPrincipal().getUID();
            person.setAttribute("username", (Object)userName);
            this.threadNamingRequestFilter.updateCurrentUsername(userName);
            GroupService.finishedSession((IPerson)person);
            this.usernameTaggedCacheEntryPurger.purgeTaggedCacheEntries(userName);
            IAdditionalDescriptor addInfo = person.getSecurityContext().getAdditionalDescriptor();
            if (addInfo != null) {
                if (addInfo instanceof IPerson) {
                    IPerson newPerson = (IPerson)addInfo;
                    person.setFullName(newPerson.getFullName());
                    Enumeration e = newPerson.getAttributeNames();
                    while (e.hasMoreElements()) {
                        String attributeName = (String)e.nextElement();
                        person.setAttribute(attributeName, newPerson.getAttribute(attributeName));
                    }
                    this.resetEntityIdentifier(person, newPerson);
                } else if (addInfo instanceof Map) {
                    Map additionalAttributes = (Map)addInfo;
                    for (String key : additionalAttributes.keySet()) {
                        person.setAttribute(key, additionalAttributes.get(key));
                    }
                } else if (!(addInfo instanceof ChainingSecurityContext.ChainingAdditionalDescriptor) && log.isWarnEnabled()) {
                    log.warn((Object)("Authentication Service recieved unknown additional descriptor [" + addInfo + "]"));
                }
            }
            if (PropertiesManager.getPropertyAsBoolean((String)"org.jasig.portal.services.Authentication.usePersonDirectory") && (personAttributes = this.personAttributeDao.getPerson(username = person.getUserName())) != null) {
                person.setAttributes(personAttributes.getAttributes());
            }
            if (person.getFullName() == null) {
                if (person.getAttribute("portalDisplayName") != null) {
                    person.setFullName((String)person.getAttribute("portalDisplayName"));
                } else if (person.getAttribute("displayName") != null) {
                    person.setFullName((String)person.getAttribute("displayName"));
                }
                if (person.getFullName() == null) {
                    person.setFullName("Unrecognized person: " + person.getAttribute("username"));
                }
            }
            if ((autocreate = PropertiesManager.getPropertyAsBoolean((String)"org.jasig.portal.services.Authentication.autoCreateUsers")) && person.getAttribute("uPortalTemplateUserName") == null) {
                String defaultTemplateUserName = PropertiesManager.getProperty((String)"org.jasig.portal.services.Authentication.defaultTemplateUserName");
                person.setAttribute("uPortalTemplateUserName", (Object)defaultTemplateUserName);
            }
            try {
                int newUID = this.userIdentityStore.getPortalUID(person, autocreate);
                person.setID(newUID);
            }
            catch (AuthorizationException ae) {
                log.error((Object)"Exception retrieving ID", (Throwable)ae);
                throw new PortalSecurityException("Authentication Service: Exception retrieving UID");
            }
        }
        this.portalEventFactory.publishLoginEvent(request, (Object)this, person);
    }

    protected void resetEntityIdentifier(IPerson person, IPerson newPerson) {
    }

    public void setContextParameters(Map<String, String> principals, Map<String, String> credentials, String ctxName, ISecurityContext securityContext, IPerson person) {
        IOpaqueCredentials credentialsInstance;
        if (log.isDebugEnabled()) {
            Map.Entry<String, String> y;
            Map.Entry<String, String> o;
            StringBuilder msg = new StringBuilder();
            msg.append("Preparing to authenticate;  setting parameters for context name '").append(ctxName).append("', context class '").append(securityContext.getClass().getName()).append("'");
            msg.append("\n\t Available Principal Tokens");
            Iterator<Map.Entry<String, String>> i$ = principals.entrySet().iterator();
            while (i$.hasNext()) {
                y = o = i$.next();
                msg.append("\n\t\t").append((Object)y.getKey()).append("=").append((Object)y.getValue());
            }
            msg.append("\n\t Available Credential Tokens");
            i$ = credentials.entrySet().iterator();
            while (i$.hasNext()) {
                y = o = i$.next();
                String val = y.getValue();
                String valWasSpecified = null;
                if (val != null) {
                    valWasSpecified = val.trim().length() == 0 ? "empty" : "provided";
                }
                msg.append("\n\t\t").append((Object)y.getKey()).append(" was ").append(valWasSpecified);
            }
            log.debug((Object)msg.toString());
        }
        String username = principals.get(ctxName);
        String credential = credentials.get(ctxName);
        username = username != null ? username : principals.get(BASE_CONTEXT_NAME);
        String string = credential = credential != null ? credential : credentials.get(BASE_CONTEXT_NAME);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Authentication::setContextParameters() username: " + username));
        }
        IPrincipal principalInstance = securityContext.getPrincipalInstance();
        if (username != null && !username.equals("")) {
            principalInstance.setUID(username);
        }
        if ((credentialsInstance = securityContext.getOpaqueCredentialsInstance()) != null) {
            credentialsInstance.setCredentials(credential);
        }
    }

    private void configureSecurityContextChain(Map<String, String> principals, Map<String, String> credentials, IPerson person, ISecurityContext securityContext, String baseContextName) throws PortalSecurityException {
        this.setContextParameters(principals, credentials, baseContextName, securityContext, person);
        Enumeration subCtxNames = securityContext.getSubContextNames();
        while (subCtxNames.hasMoreElements()) {
            String fullSubCtxName;
            String localSubCtxName = fullSubCtxName = (String)subCtxNames.nextElement();
            if (fullSubCtxName.startsWith(baseContextName + ".")) {
                localSubCtxName = localSubCtxName.substring(baseContextName.length() + 1);
            }
            ISecurityContext sc = securityContext.getSubContext(localSubCtxName);
            this.configureSecurityContextChain(principals, credentials, person, sc, fullSubCtxName);
        }
    }
}

