/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.services;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.AuthorizationException;
import org.jasig.portal.groups.GroupsException;
import org.jasig.portal.groups.IGroupMember;
import org.jasig.portal.security.IAuthorizationPrincipal;
import org.jasig.portal.security.IAuthorizationService;
import org.jasig.portal.security.IAuthorizationServiceFactory;
import org.jasig.portal.security.IPermission;
import org.jasig.portal.security.IPermissionManager;
import org.jasig.portal.security.IUpdatingPermissionManager;
import org.jasig.portal.security.PortalSecurityException;
import org.jasig.portal.utils.threading.SingletonDoubleCheckedCreator;

public class AuthorizationService {
    private static final Log log;
    private static final SingletonDoubleCheckedCreator<AuthorizationService> authorizationServiceInstance;
    protected IAuthorizationService m_authorization = m_Factory.getAuthorization();
    protected static String s_factoryName;
    protected static IAuthorizationServiceFactory m_Factory;

    private AuthorizationService() throws AuthorizationException {
    }

    public IGroupMember getGroupMember(IAuthorizationPrincipal principal) throws GroupsException {
        return this.m_authorization.getGroupMember(principal);
    }

    public static final AuthorizationService instance() throws AuthorizationException {
        return (AuthorizationService)authorizationServiceInstance.get(new Object[0]);
    }

    public IPermissionManager newPermissionManager(String owner) throws AuthorizationException {
        return this.m_authorization.newPermissionManager(owner);
    }

    public IAuthorizationPrincipal newPrincipal(String key, Class type) throws AuthorizationException {
        return this.m_authorization.newPrincipal(key, type);
    }

    public IAuthorizationPrincipal newPrincipal(IGroupMember groupMember) throws GroupsException {
        return this.m_authorization.newPrincipal(groupMember);
    }

    public IAuthorizationPrincipal newPrincipal(IPermission permission) throws AuthorizationException {
        return this.m_authorization.getPrincipal(permission);
    }

    public IUpdatingPermissionManager newUpdatingPermissionManager(String owner) throws AuthorizationException {
        return this.m_authorization.newUpdatingPermissionManager(owner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        block16: {
            log = LogFactory.getLog(AuthorizationService.class);
            authorizationServiceInstance = new /* Unavailable Anonymous Inner Class!! */;
            s_factoryName = null;
            m_Factory = null;
            InputStream secprops = AuthorizationService.class.getResourceAsStream("/properties/security.properties");
            Properties pr = new Properties();
            try {
                pr.load(secprops);
                secprops.close();
                s_factoryName = pr.getProperty("authorizationProvider");
                if (s_factoryName == null) {
                    log.error((Object)"AuthorizationProvider not specified or incorrect in security.properties", (Throwable)new PortalSecurityException("AuthorizationProvider not specified or incorrect in security.properties"));
                    break block16;
                }
                try {
                    m_Factory = (IAuthorizationServiceFactory)Class.forName(s_factoryName).newInstance();
                }
                catch (Exception e) {
                    log.error((Object)("Failed to instantiate AuthorizationProvider " + s_factoryName), (Throwable)new PortalSecurityException("Failed to instantiate AuthorizationProvider " + s_factoryName));
                }
                if (m_Factory == null) {
                    log.error((Object)"AuthorizationProvider not specified or incorrect in security.properties", (Throwable)new PortalSecurityException("AuthorizationProvider not specified or incorrect in security.properties"));
                }
            }
            catch (IOException e) {
                log.error((Object)"Error loading security properties", (Throwable)e);
            }
            finally {
                try {
                    if (secprops != null) {
                        secprops.close();
                    }
                }
                catch (IOException ioe) {
                    log.error((Object)"Error closing security properties file.", (Throwable)ioe);
                }
            }
        }
    }
}

