/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.services;

import javax.naming.InvalidNameException;
import javax.naming.Name;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.EntityIdentifier;
import org.jasig.portal.concurrency.CachingException;
import org.jasig.portal.groups.CompositeEntityIdentifier;
import org.jasig.portal.groups.CompositeServiceIdentifier;
import org.jasig.portal.groups.GroupServiceConfiguration;
import org.jasig.portal.groups.GroupsException;
import org.jasig.portal.groups.ICompositeGroupService;
import org.jasig.portal.groups.ICompositeGroupServiceFactory;
import org.jasig.portal.groups.IEntity;
import org.jasig.portal.groups.IEntityGroup;
import org.jasig.portal.groups.IGroupConstants;
import org.jasig.portal.groups.IGroupMember;
import org.jasig.portal.groups.IGroupService;
import org.jasig.portal.groups.IGroupServiceFactory;
import org.jasig.portal.groups.ILockableEntityGroup;
import org.jasig.portal.properties.PropertiesManager;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.services.EntityCachingService;
import org.jasig.portal.utils.threading.SingletonDoubleCheckedCreator;

/*
 * Exception performing whole class analysis ignored.
 */
public class GroupService
implements IGroupConstants {
    private static final Log log = LogFactory.getLog(GroupService.class);
    private static final SingletonDoubleCheckedCreator<GroupService> instance = new /* Unavailable Anonymous Inner Class!! */;
    private static boolean composite;
    private IGroupService groupService = null;
    private ICompositeGroupService compositeGroupService = null;
    protected static final String GROUP_SERVICE_KEY = "org.jasig.portal.services.GroupService.key_";

    private GroupService() throws GroupsException {
        this.initializeCompositeService();
    }

    public static IEntityGroup findGroup(String key) throws GroupsException {
        return GroupService.instance().ifindGroup(key);
    }

    public static ILockableEntityGroup findLockableGroup(String key, String lockOwner) throws GroupsException {
        return GroupService.instance().ifindLockableGroup(key, lockOwner);
    }

    public static void finishedSession(IPerson person) {
        try {
            GroupService.instance().ifinishedSession(person);
        }
        catch (GroupsException ge) {
            log.error((Object)("Error upon session finishing for person [" + person + "]"), (Throwable)ge);
        }
    }

    public static ICompositeGroupService getCompositeGroupService() throws GroupsException {
        return GroupService.instance().compositeGroupService;
    }

    protected String getDefaultServiceName() throws GroupsException {
        return (String)this.getServiceConfiguration().getAttributes().get("defaultService");
    }

    public static IEntityGroup getDistinguishedGroup(String name) throws GroupsException {
        return GroupService.instance().igetDistinguishedGroup(name);
    }

    public String getDistinguishedGroupKey(String name) {
        return PropertiesManager.getProperty((String)("org.jasig.portal.services.GroupService.key_" + name), (String)"");
    }

    public static IEntity getEntity(String key, Class type) throws GroupsException {
        return GroupService.getEntity((String)key, (Class)type, null);
    }

    public static IEntity getEntity(String key, Class type, String service) throws GroupsException {
        return GroupService.instance().igetEntity(key, type, service);
    }

    public static IGroupMember getGroupMember(String key, Class type) throws GroupsException {
        return GroupService.instance().igetGroupMember(key, type);
    }

    public static IGroupMember getGroupMember(EntityIdentifier underlyingEntityIdentifier) throws GroupsException {
        return GroupService.getGroupMember((String)underlyingEntityIdentifier.getKey(), (Class)underlyingEntityIdentifier.getType());
    }

    public static IGroupService getGroupService() throws GroupsException {
        return GroupService.instance().groupService;
    }

    public static IEntityGroup getRootGroup(Class type) throws GroupsException {
        return GroupService.instance().igetRootGroup(type);
    }

    protected GroupServiceConfiguration getServiceConfiguration() throws GroupsException {
        try {
            return GroupServiceConfiguration.getConfiguration();
        }
        catch (Exception ex) {
            throw new GroupsException("Problem retrieving service configuration", (Throwable)ex);
        }
    }

    protected IEntityGroup ifindGroup(String key) throws GroupsException {
        return this.compositeGroupService.findGroup(key);
    }

    protected ILockableEntityGroup ifindLockableGroup(String key, String lockOwner) throws GroupsException {
        return this.compositeGroupService.findGroupWithLock(key, lockOwner);
    }

    protected void ifinishedSession(IPerson person) throws GroupsException {
        IGroupMember gm = GroupService.getGroupMember((EntityIdentifier)person.getEntityIdentifier());
        try {
            EntityIdentifier entityIdentifier = gm.getEntityIdentifier();
            EntityCachingService.getEntityCachingService().remove(entityIdentifier.getType(), entityIdentifier.getKey());
        }
        catch (CachingException ce) {
            throw new GroupsException("Problem removing group member " + gm.getKey() + " from cache", (Throwable)ce);
        }
    }

    protected IEntityGroup igetDistinguishedGroup(String name) throws GroupsException {
        try {
            String key = this.getDistinguishedGroupKey(name);
            return this.compositeGroupService.findGroup(key);
        }
        catch (Exception ex) {
            throw new GroupsException("GroupService.getDistinguishedGroup(): could not find key for: " + name, (Throwable)ex);
        }
    }

    protected IEntity igetEntity(String key, Class type, String service) throws GroupsException {
        return this.compositeGroupService.getEntity(key, type, service);
    }

    protected IGroupMember igetGroupMember(String key, Class type) throws GroupsException {
        return this.compositeGroupService.getGroupMember(key, type);
    }

    protected IEntityGroup igetRootGroup(Class type) throws GroupsException {
        return this.igetDistinguishedGroup(type.getName());
    }

    protected IEntityGroup inewGroup(Class type) throws GroupsException {
        return this.inewGroup(type, this.getDefaultServiceName());
    }

    protected IEntityGroup inewGroup(Class type, String serviceName) throws GroupsException {
        try {
            return this.compositeGroupService.newGroup(type, GroupService.parseServiceName((String)serviceName));
        }
        catch (InvalidNameException ine) {
            throw new GroupsException("GroupService.inewGroup(): invalid service name", (Throwable)ine);
        }
    }

    private void initialize() throws GroupsException {
        composite = false;
        String eMsg = null;
        String factoryName = PropertiesManager.getProperty((String)"org.jasig.portal.groups.GroupServiceFactory");
        if (factoryName == null) {
            eMsg = "GroupService.initialize(): No entry for org.jasig.portal.groups.GroupServiceFactory in portal.properties.";
            log.error((Object)eMsg);
            throw new GroupsException(eMsg);
        }
        try {
            IGroupServiceFactory groupServiceFactory = (IGroupServiceFactory)Class.forName(factoryName).newInstance();
            this.groupService = groupServiceFactory.newGroupService();
        }
        catch (Exception e) {
            eMsg = "GroupService.initialize(): Problem creating groups service...";
            log.error((Object)eMsg, (Throwable)e);
            throw new GroupsException(eMsg, (Throwable)e);
        }
    }

    private void initializeCompositeService() throws GroupsException {
        composite = true;
        String eMsg = null;
        try {
            GroupServiceConfiguration cfg = this.getServiceConfiguration();
            String factoryName = (String)cfg.getAttributes().get("compositeFactory");
            if (factoryName == null) {
                eMsg = "GroupService.initialize(): No entry for CompositeServiceFactory in configuration";
                log.error((Object)eMsg);
                throw new GroupsException(eMsg);
            }
            ICompositeGroupServiceFactory serviceFactory = (ICompositeGroupServiceFactory)Class.forName(factoryName).newInstance();
            this.compositeGroupService = serviceFactory.newGroupService();
        }
        catch (Exception e) {
            eMsg = "GroupService.initialize(): Problem creating groups service... " + e.getMessage();
            log.error((Object)eMsg, (Throwable)e);
            throw new GroupsException(eMsg, (Throwable)e);
        }
    }

    public static GroupService instance() throws GroupsException {
        return (GroupService)instance.get(new Object[0]);
    }

    public static boolean isComposite() {
        return composite;
    }

    public static IEntityGroup newGroup(Class type) throws GroupsException {
        return GroupService.instance().inewGroup(type);
    }

    public static IEntityGroup newGroup(Class type, String serviceName) throws GroupsException {
        return GroupService.instance().inewGroup(type, serviceName);
    }

    public static String parseLocalKey(String compositeKey) throws InvalidNameException, GroupsException {
        return new CompositeEntityIdentifier(compositeKey, new Object().getClass()).getLocalKey();
    }

    public static Name parseServiceName(String serviceName) throws InvalidNameException, GroupsException {
        return new CompositeServiceIdentifier(serviceName).getServiceName();
    }

    public static EntityIdentifier[] searchForEntities(String query, int method, Class type) throws GroupsException {
        return GroupService.instance().compositeGroupService.searchForEntities(query, method, type);
    }

    public static EntityIdentifier[] searchForEntities(String query, int method, Class type, IEntityGroup ancestor) throws GroupsException {
        return GroupService.instance().compositeGroupService.searchForEntities(query, method, type, ancestor);
    }

    public static EntityIdentifier[] searchForGroups(String query, int method, Class leaftype) throws GroupsException {
        return GroupService.instance().compositeGroupService.searchForGroups(query, method, leaftype);
    }

    public static EntityIdentifier[] searchForGroups(String query, int method, Class leaftype, IEntityGroup ancestor) throws GroupsException {
        return GroupService.instance().compositeGroupService.searchForGroups(query, method, leaftype, ancestor);
    }

    public static void startUp() throws GroupsException {
        GroupService.instance();
    }
}

