/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.spring.beans.factory;

import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.util.Assert;

public class MediatingFactoryBean<T>
extends AbstractFactoryBean<T>
implements BeanFactoryAware {
    private List<String> delegateBeanNames;
    private Class<T> type = null;

    public List<String> getDelegateBeanNames() {
        return this.delegateBeanNames;
    }

    public void setDelegateBeanNames(List<String> delegateBeanNames) {
        this.delegateBeanNames = delegateBeanNames;
    }

    public Class<T> getType() {
        return this.type;
    }

    public void setType(Class<T> type) {
        this.type = type;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notEmpty((Collection)this.delegateBeanNames, (String)"delegateBeanNames list cannot be empty");
        super.afterPropertiesSet();
    }

    protected T createInstance() throws Exception {
        for (String beanName : this.delegateBeanNames) {
            try {
                Object bean = this.type == null ? this.getBeanFactory().getBean(beanName) : this.getBeanFactory().getBean(beanName, this.type);
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("Loaded bean for name " + beanName));
                }
                return (T)bean;
            }
            catch (Exception e) {
                String msg = "Failed to load bean '" + beanName + "' from ApplicationContext" + (this.type != null ? " expecting type: " + this.type : "") + ". Will try to load the next bean in the list instead. Error message from the attempt to load this bean ('" + beanName + "'): ";
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)msg, (Throwable)e);
                    continue;
                }
                if (!this.logger.isInfoEnabled()) continue;
                this.logger.info((Object)(msg + " " + e.getMessage() + " (enable debug for stack trace)"));
            }
        }
        throw new BeanCreationException("None of the configured bean names could be loaded. BeanNames: " + this.delegateBeanNames);
    }

    public Class<?> getObjectType() {
        return this.type;
    }
}

