/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.spring.context;

import com.google.common.collect.MapMaker;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jasig.portal.spring.context.ApplicationEventFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.GenericTypeResolver;

public class ClassApplicationEventFilter<E extends ApplicationEvent>
implements ApplicationEventFilter<E>,
InitializingBean {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<Class<? extends ApplicationEvent>, Boolean> supportedEventsCache = new MapMaker().weakKeys().makeMap();
    private Class<?> typeArg;
    private Set<Class<? extends ApplicationEvent>> supportedEvents = Collections.emptySet();
    private Set<Class<? extends ApplicationEvent>> ignoredEvents = Collections.emptySet();

    public void setSupportedEvents(Collection<Class<? extends ApplicationEvent>> supportedEvents) {
        this.supportedEventsCache.clear();
        this.supportedEvents = supportedEvents == null ? Collections.emptySet() : new LinkedHashSet<Class<? extends ApplicationEvent>>(supportedEvents);
    }

    public void setIgnoredEvents(Collection<Class<? extends ApplicationEvent>> ignoredEvents) {
        this.supportedEventsCache.clear();
        this.ignoredEvents = ignoredEvents == null ? Collections.emptySet() : new LinkedHashSet<Class<? extends ApplicationEvent>>(ignoredEvents);
    }

    public void afterPropertiesSet() throws Exception {
        Class targetClass;
        Class typeArg = GenericTypeResolver.resolveTypeArgument(this.getClass(), ApplicationListener.class);
        if ((typeArg == null || typeArg.equals(ApplicationEvent.class)) && (targetClass = AopUtils.getTargetClass((Object)this)) != this.getClass()) {
            typeArg = GenericTypeResolver.resolveTypeArgument((Class)targetClass, ApplicationListener.class);
        }
        this.typeArg = typeArg;
    }

    public boolean supports(E event) {
        Class<?> eventType = event.getClass();
        Boolean cachedSupports = (Boolean)this.supportedEventsCache.get(eventType);
        if (cachedSupports != null) {
            return cachedSupports;
        }
        boolean supports = this.supportsEventTypeHelper(eventType);
        this.supportedEventsCache.put(eventType, supports);
        return supports;
    }

    private boolean supportsEventTypeHelper(Class<? extends ApplicationEvent> eventType) {
        if (this.typeArg != null && !this.typeArg.isAssignableFrom(eventType)) {
            return false;
        }
        if (this.ignoredEvents.contains(eventType)) {
            return false;
        }
        if (this.supportedEvents.contains(eventType)) {
            return true;
        }
        for (Class includedType : this.ignoredEvents) {
            if (!includedType.isAssignableFrom(eventType)) continue;
            return false;
        }
        for (Class includedType : this.supportedEvents) {
            if (!includedType.isAssignableFrom(eventType)) continue;
            return true;
        }
        return this.supportedEvents.isEmpty();
    }
}

