/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.spring.context;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jasig.portal.spring.context.ApplicationEventFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.OrderComparator;

public abstract class FilteringApplicationListener<E extends ApplicationEvent>
implements ApplicationListener<E> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private List<ApplicationEventFilter<E>> applicationEventFilters = Collections.emptyList();

    public final void setApplicationEventFilters(List<ApplicationEventFilter<E>> applicationEventFilters) {
        applicationEventFilters = new ArrayList<ApplicationEventFilter<ApplicationEventFilter<E>>>(applicationEventFilters);
        Collections.sort(applicationEventFilters, OrderComparator.INSTANCE);
        this.applicationEventFilters = ImmutableList.copyOf(applicationEventFilters);
    }

    public final void onApplicationEvent(E event) {
        for (ApplicationEventFilter applicationEventFilter : this.applicationEventFilters) {
            if (applicationEventFilter.supports(event)) continue;
            this.logger.debug("Filter {} does not support event {} it will be ignored", (Object)applicationEventFilter, event);
            return;
        }
        this.onFilteredApplicationEvent(event);
    }

    protected abstract void onFilteredApplicationEvent(E var1);
}

