/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.spring.security.evaluator;

import java.io.Serializable;
import org.jasig.portal.layout.dlm.remoting.IGroupListHelper;
import org.jasig.portal.layout.dlm.remoting.JsonEntityBean;
import org.jasig.portal.portlets.groupselector.EntityEnum;
import org.jasig.portal.security.IAuthorizationPrincipal;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.services.AuthorizationService;
import org.jasig.portal.spring.security.evaluator.AuthorizableActivity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.PermissionEvaluator;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.UserDetails;

public class PortalPermissionEvaluator
implements PermissionEvaluator {
    private IGroupListHelper groupListHelper;
    private AuthorizationService authorizationService;

    @Autowired(required=true)
    public void setGroupListHelper(IGroupListHelper groupListHelper) {
        this.groupListHelper = groupListHelper;
    }

    public boolean hasPermission(Authentication authentication, Object targetDomainObject, Object permission) {
        if (this.authorizationService == null) {
            this.authorizationService = AuthorizationService.instance();
        }
        UserDetails userDetails = (UserDetails)authentication.getPrincipal();
        IAuthorizationPrincipal principal = this.authorizationService.newPrincipal(userDetails.getUsername(), IPerson.class);
        String targetId = null;
        if (targetDomainObject instanceof String) {
            targetId = (String)targetDomainObject;
        } else if (targetDomainObject instanceof JsonEntityBean) {
            targetId = ((JsonEntityBean)targetDomainObject).getTargetString();
        }
        AuthorizableActivity activity = null;
        if (permission instanceof AuthorizableActivity) {
            activity = (AuthorizableActivity)permission;
        } else if (permission instanceof String) {
            String activityName = (String)permission;
            activity = this.getViewActivity(activityName, (JsonEntityBean)targetDomainObject);
        } else {
            throw new RuntimeException("Unable to determine permission target id for type " + targetDomainObject.getClass());
        }
        if (activity != null) {
            boolean hasPermission = principal.hasPermission(activity.getOwnerFname(), activity.getActivityFname(), targetId);
            return hasPermission;
        }
        return false;
    }

    public boolean hasPermission(Authentication authentication, Serializable targetId, String targetType, Object permission) {
        if (this.authorizationService == null) {
            this.authorizationService = AuthorizationService.instance();
        }
        UserDetails userDetails = (UserDetails)authentication.getPrincipal();
        IAuthorizationPrincipal principal = this.authorizationService.newPrincipal(userDetails.getUsername(), IPerson.class);
        AuthorizableActivity activity = null;
        if (permission instanceof AuthorizableActivity) {
            activity = (AuthorizableActivity)permission;
        } else if (permission instanceof String && targetId instanceof String) {
            String activityName = (String)permission;
            activity = this.getViewActivity(activityName, (String)((Object)targetId));
        }
        if (activity != null) {
            boolean hasPermission = principal.hasPermission(activity.getOwnerFname(), activity.getActivityFname(), targetId.toString());
            return hasPermission;
        }
        return false;
    }

    protected AuthorizableActivity getViewActivity(String activityKey, JsonEntityBean entity) {
        if (entity != null && activityKey.equals("VIEW")) {
            EntityEnum type = entity.getEntityType();
            if (type.isGroup()) {
                return new AuthorizableActivity("UP_GROUPS", "VIEW_GROUP");
            }
            if (type.equals((Object)EntityEnum.PERSON)) {
                return new AuthorizableActivity("UP_USERS", "VIEW_USER");
            }
            if (type.equals((Object)EntityEnum.PORTLET)) {
                return new AuthorizableActivity("UP_PORTLET_SUBSCRIBE", "SUBSCRIBE");
            }
        }
        return null;
    }

    protected AuthorizableActivity getViewActivity(String activityKey, String target) {
        JsonEntityBean entity = this.groupListHelper.getEntityForPrincipal(target);
        return this.getViewActivity(activityKey, entity);
    }
}

