/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.spring.web.context.support;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.spring.web.context.support.FailsafeSingletonScope;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.config.Scope;

public class FailsafeSingletonScope
implements Scope,
DisposableBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final Map<String, InstanceHolder> instances = new HashMap();
    private final Scope delegateScope;

    public FailsafeSingletonScope(Scope delegateScope) {
        this.delegateScope = delegateScope;
    }

    public void destroy() throws Exception {
        for (InstanceHolder instanceHolder : this.instances.values()) {
            if (instanceHolder.destructionCallback == null) continue;
            try {
                instanceHolder.destructionCallback.run();
            }
            catch (Exception e) {
                this.logger.warn((Object)("Destruction callback for bean named '" + instanceHolder.name + "' failed."), (Throwable)e);
            }
        }
        this.instances.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(String name, ObjectFactory<?> objectFactory) {
        try {
            return this.delegateScope.get(name, objectFactory);
        }
        catch (IllegalStateException ise) {
            Map map = this.instances;
            synchronized (map) {
                InstanceHolder instanceHolder = (InstanceHolder)this.instances.get(name);
                if (instanceHolder == null) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Creating singleton instance for bean '" + name + "'"));
                    }
                    instanceHolder = new InstanceHolder(name);
                    this.instances.put(name, instanceHolder);
                    instanceHolder.instance = objectFactory.getObject();
                } else if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Using existing singleton instance for bean '" + name + "'"));
                }
                return instanceHolder.instance;
            }
        }
    }

    public String getConversationId() {
        try {
            return this.delegateScope.getConversationId();
        }
        catch (IllegalStateException ise) {
            return "NO_SESSION_SINGLETON";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerDestructionCallback(String name, Runnable callback) {
        block7: {
            try {
                this.delegateScope.registerDestructionCallback(name, callback);
            }
            catch (IllegalStateException ise) {
                InstanceHolder instanceHolder;
                Map map = this.instances;
                synchronized (map) {
                    instanceHolder = (InstanceHolder)this.instances.get(name);
                }
                if (instanceHolder != null) {
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info((Object)("Adding destruction callback singleton for bean '" + name + "'"));
                    }
                    instanceHolder.destructionCallback = callback;
                }
                if (!this.logger.isInfoEnabled()) break block7;
                this.logger.info((Object)("Ignoring destruction callback for singleton bean '" + name + "' because there currently is no instance"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(String name) {
        try {
            return this.delegateScope.remove(name);
        }
        catch (IllegalStateException ise) {
            InstanceHolder instanceHolder;
            Map map = this.instances;
            synchronized (map) {
                instanceHolder = (InstanceHolder)this.instances.remove(name);
            }
            if (instanceHolder != null) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("Removing singleton bean '" + name + "'"));
                }
                return instanceHolder.instance;
            }
            return null;
        }
    }

    public Object resolveContextualObject(String arg0) {
        return null;
    }
}

