/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.spring.web.flow;

import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;
import org.jasig.portal.EntityIdentifier;
import org.jasig.portal.security.IAuthorizationPrincipal;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.security.IPersonManager;
import org.jasig.portal.services.AuthorizationService;
import org.jasig.portal.spring.web.flow.IPortalWebFlowUtils;
import org.jasig.portal.url.IPortalRequestUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.webflow.context.ExternalContext;

@Component(value="portalWebFlowUtils")
public class PortalWebFlowUtilsImpl
implements IPortalWebFlowUtils {
    private IPortalRequestUtils portalRequestUtils;
    private IPersonManager personManager;

    @Autowired(required=true)
    public void setPortalRequestUtils(IPortalRequestUtils portalRequestUtils) {
        this.portalRequestUtils = portalRequestUtils;
    }

    @Autowired(required=true)
    public void setPersonManager(IPersonManager personManager) {
        this.personManager = personManager;
    }

    public IPerson getCurrentPerson(ExternalContext externalContext) {
        HttpServletRequest servletRequest = this.getServletRequestFromExternalContext(externalContext);
        return this.personManager.getPerson(servletRequest);
    }

    public IAuthorizationPrincipal getCurrentPrincipal(ExternalContext externalContext) {
        IPerson person = this.getCurrentPerson(externalContext);
        EntityIdentifier ei = person.getEntityIdentifier();
        return AuthorizationService.instance().newPrincipal(ei.getKey(), ei.getType());
    }

    protected HttpServletRequest getServletRequestFromExternalContext(ExternalContext externalContext) {
        Object request = externalContext.getNativeRequest();
        if (request instanceof PortletRequest) {
            return this.portalRequestUtils.getPortletHttpRequest((PortletRequest)externalContext.getNativeRequest());
        }
        if (request instanceof HttpServletRequest) {
            return (HttpServletRequest)request;
        }
        throw new IllegalArgumentException("Unable to recognize the native request associated with the supplied external context");
    }
}

