/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.tools.dbloader;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.NullWriter;
import org.apache.commons.lang.StringUtils;
import org.hibernate.cfg.Configuration;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.internal.FormatStyle;
import org.hibernate.engine.jdbc.internal.Formatter;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.jasig.portal.hibernate.DelegatingHibernateIntegrator;
import org.jasig.portal.hibernate.HibernateConfigurationAware;
import org.jasig.portal.tools.dbloader.ISchemaExport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.jdbc.core.ConnectionCallback;
import org.springframework.jdbc.core.JdbcOperations;

public class DataSourceSchemaExport
implements ISchemaExport,
HibernateConfigurationAware {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Formatter formatter = FormatStyle.DDL.getFormatter();
    private JdbcOperations jdbcOperations;
    private Configuration configuration;
    private Dialect dialect;
    private String persistenceUnit;

    @Required
    public void setPersistenceUnit(String persistenceUnit) {
        this.persistenceUnit = persistenceUnit;
    }

    @Required
    public void setJdbcOperations(JdbcOperations jdbcOperations) {
        this.jdbcOperations = jdbcOperations;
    }

    public boolean supports(String persistenceUnit) {
        return this.persistenceUnit.equals(persistenceUnit);
    }

    public String getPersistenceUnitName() {
        return this.persistenceUnit;
    }

    public void setConfiguration(String persistenceUnit, DelegatingHibernateIntegrator.HibernateConfiguration hibernateConfiguration) {
        this.configuration = hibernateConfiguration.getConfiguration();
        SessionFactoryImplementor sessionFactory = hibernateConfiguration.getSessionFactory();
        this.dialect = sessionFactory.getDialect();
    }

    public void drop(boolean export, String outputFile, boolean append) {
        String[] dropSQL = this.configuration.generateDropSchemaScript(this.dialect);
        this.perform(dropSQL, export, outputFile, append, false);
    }

    public void create(boolean export, String outputFile, boolean append) {
        String[] createSQL = this.configuration.generateSchemaCreationScript(this.dialect);
        this.perform(createSQL, export, outputFile, append, true);
    }

    public void update(boolean export, String outputFile, boolean append) {
        String[] updateSQL = (String[])this.jdbcOperations.execute((ConnectionCallback)new /* Unavailable Anonymous Inner Class!! */);
        this.perform(updateSQL, export, outputFile, append, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void perform(String[] sqlCommands, boolean executeSql, String outputFile, boolean append, boolean failFast) {
        PrintWriter sqlWriter = this.getSqlWriter(outputFile, append);
        try {
            for (String sqlCommand : sqlCommands) {
                String formatted = this.formatter.format(sqlCommand);
                sqlWriter.println(formatted);
                if (!executeSql) continue;
                try {
                    this.jdbcOperations.execute(sqlCommand);
                    this.logger.info(sqlCommand);
                }
                catch (Exception e) {
                    if (failFast) {
                        this.logger.error("Failed to execute: {}\n\t{}", (Object)sqlCommand, (Object)e.getMessage());
                        throw new RuntimeException("Failed to execute: " + sqlCommand, e);
                    }
                    if (this.logger.isDebugEnabled()) {
                        this.logger.info("Failed to execute: " + sqlCommand, (Throwable)e);
                        continue;
                    }
                    this.logger.info("Failed to execute (probably ignorable): {}", (Object)sqlCommand);
                }
            }
        }
        finally {
            IOUtils.closeQuietly((Writer)sqlWriter);
        }
    }

    private PrintWriter getSqlWriter(String outputFile, boolean append) {
        Object sqlWriter;
        if (StringUtils.trimToNull((String)outputFile) != null) {
            try {
                sqlWriter = new BufferedWriter(new FileWriter(outputFile, append));
            }
            catch (IOException e) {
                throw new RuntimeException("", e);
            }
        } else {
            sqlWriter = new NullWriter();
        }
        return new PrintWriter((Writer)sqlWriter);
    }

    static /* synthetic */ Dialect access$000(DataSourceSchemaExport x0) {
        return x0.dialect;
    }

    static /* synthetic */ Configuration access$100(DataSourceSchemaExport x0) {
        return x0.configuration;
    }
}

