/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.url;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.security.IAuthorizationPrincipal;
import org.jasig.portal.security.IAuthorizationService;
import org.jasig.portal.security.IPermission;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.security.IPersonManager;
import org.jasig.portal.security.ISecurityContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class MaxInactiveInterceptor
extends HandlerInterceptorAdapter {
    protected final Log log = LogFactory.getLog(this.getClass());
    private IPersonManager personManager;
    private IAuthorizationService authorizationService;

    @Autowired
    public void setPersonManager(IPersonManager personManager) {
        this.personManager = personManager;
    }

    @Autowired
    public void setAuthorizationService(IAuthorizationService authorizationService) {
        this.authorizationService = authorizationService;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        HttpSession session = request.getSession(false);
        if (session == null) {
            return true;
        }
        IPerson person = this.personManager.getPerson(request);
        if (person == null) {
            return true;
        }
        ISecurityContext securityContext = person.getSecurityContext();
        if (securityContext != null && securityContext.isAuthenticated()) {
            IPermission[] permissions;
            IAuthorizationPrincipal principal = this.authorizationService.newPrincipal((String)person.getAttribute("username"), IPerson.class);
            Integer rulingGrant = null;
            Integer rulingDeny = null;
            for (IPermission p : permissions = this.authorizationService.getAllPermissionsForPrincipal(principal, null, "MAX_INACTIVE", null)) {
                long now = System.currentTimeMillis();
                if (p.getEffective() != null && p.getEffective().getTime() > now || p.getExpires() != null && p.getExpires().getTime() < now) continue;
                if (p.getType().equals("GRANT")) {
                    try {
                        Integer grantEntry = Integer.valueOf(p.getTarget());
                        if (rulingGrant != null && grantEntry >= 0 && rulingGrant >= grantEntry) continue;
                        rulingGrant = grantEntry;
                    }
                    catch (NumberFormatException nfe) {
                        this.log.warn((Object)("Invalid MAX_INACTIVE permission grant '" + p.getTarget() + "';  target must be an integer value."));
                    }
                    continue;
                }
                if (p.getType().equals("DENY")) {
                    try {
                        Integer denyEntry = Integer.valueOf(p.getTarget());
                        if (rulingDeny != null && rulingDeny <= denyEntry) continue;
                        rulingDeny = denyEntry;
                    }
                    catch (NumberFormatException nfe) {
                        this.log.warn((Object)("Invalid MAX_INACTIVE permission deny '" + p.getTarget() + "';  target must be an integer value."));
                    }
                    continue;
                }
                this.log.warn((Object)("Unknown permission type:  " + p.getType()));
            }
            if (rulingDeny != null && rulingDeny < 0) {
                this.log.warn((Object)("A MAX_INACTIVE DENY entry improperly specified a negative target:  " + rulingDeny));
                rulingDeny = null;
            }
            if (rulingGrant != null || rulingDeny != null) {
                int maxInactive;
                int n = maxInactive = rulingGrant != null ? rulingGrant : 0;
                if (rulingDeny != null) {
                    int limit = rulingDeny;
                    maxInactive = maxInactive >= 0 ? (limit < maxInactive ? limit : maxInactive) : limit;
                }
                session.setMaxInactiveInterval(maxInactive);
                if (this.log.isInfoEnabled()) {
                    this.log.info((Object)("Setting maxInactive to '" + maxInactive + "' for user '" + person.getAttribute("username") + "'"));
                }
            }
        }
        return true;
    }
}

