/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.url;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jasig.portal.portlet.om.IPortletWindowId;
import org.jasig.portal.url.IPortalRequestInfo;
import org.jasig.portal.url.IPortletRequestInfo;
import org.jasig.portal.url.PortletRequestInfoImpl;
import org.jasig.portal.url.UrlState;
import org.jasig.portal.url.UrlType;

class PortalRequestInfoImpl
implements IPortalRequestInfo {
    private final Object readOnlySync = new Object();
    private boolean readOnly = false;
    private String targetedLayoutNodeId;
    private IPortletWindowId targetedPortletWindowId;
    private Map<IPortletWindowId, PortletRequestInfoImpl> portletRequestInfo = new LinkedHashMap();
    private UrlState urlState = UrlState.NORMAL;
    private UrlType urlType = UrlType.RENDER;
    private Map<String, List<String>> portalParameters = new LinkedHashMap();

    PortalRequestInfoImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeReadOnly() {
        Object object = this.readOnlySync;
        synchronized (object) {
            if (this.readOnly) {
                return;
            }
            for (PortletRequestInfoImpl portletRequestInfoImpl : this.portletRequestInfo.values()) {
                portletRequestInfoImpl.makeReadOnly();
            }
            this.portletRequestInfo = Collections.unmodifiableMap(this.portletRequestInfo);
            for (Map.Entry entry : this.portalParameters.entrySet()) {
                entry.setValue(Collections.unmodifiableList((List)entry.getValue()));
            }
            this.portalParameters = Collections.unmodifiableMap(this.portalParameters);
            this.readOnly = true;
        }
    }

    private void checkReadOnly() {
        if (this.readOnly) {
            throw new UnsupportedOperationException("makeReadOnly has been called, this object is in read-only mode");
        }
    }

    public String getTargetedLayoutNodeId() {
        return this.targetedLayoutNodeId;
    }

    public void setTargetedLayoutNodeId(String targetedLayoutNodeId) {
        this.checkReadOnly();
        this.targetedLayoutNodeId = targetedLayoutNodeId;
    }

    public IPortletWindowId getTargetedPortletWindowId() {
        return this.targetedPortletWindowId;
    }

    public void setTargetedPortletWindowId(IPortletWindowId targetedPortletWindowId) {
        this.checkReadOnly();
        this.targetedPortletWindowId = targetedPortletWindowId;
    }

    public IPortletRequestInfo getTargetedPortletRequestInfo() {
        if (this.targetedPortletWindowId == null) {
            return null;
        }
        if (this.readOnly) {
            return (IPortletRequestInfo)this.portletRequestInfo.get(this.targetedPortletWindowId);
        }
        return this.getPortletRequestInfo(this.targetedPortletWindowId);
    }

    public Map<IPortletWindowId, PortletRequestInfoImpl> getPortletRequestInfoMap() {
        return this.portletRequestInfo;
    }

    public PortletRequestInfoImpl getPortletRequestInfo(IPortletWindowId portletWindowId) {
        PortletRequestInfoImpl portletRequestInfo = (PortletRequestInfoImpl)this.portletRequestInfo.get(portletWindowId);
        if (this.readOnly || portletRequestInfo != null) {
            return portletRequestInfo;
        }
        portletRequestInfo = new PortletRequestInfoImpl(portletWindowId, (IPortalRequestInfo)this);
        this.portletRequestInfo.put(portletWindowId, portletRequestInfo);
        return portletRequestInfo;
    }

    public UrlState getUrlState() {
        return this.urlState;
    }

    public void setUrlState(UrlState urlState) {
        this.checkReadOnly();
        Preconditions.checkNotNull((Object)urlState, (Object)"Cannot set a null UrlState");
        this.urlState = urlState;
    }

    public UrlType getUrlType() {
        return this.urlType;
    }

    public void setUrlType(UrlType urlType) {
        this.checkReadOnly();
        Preconditions.checkNotNull((Object)urlType, (Object)"Cannot set a null UrlType");
        this.urlType = urlType;
    }

    public Map<String, List<String>> getPortalParameters() {
        return this.portalParameters;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.targetedLayoutNodeId == null ? 0 : this.targetedLayoutNodeId.hashCode());
        result = 31 * result + (this.targetedPortletWindowId == null ? 0 : this.targetedPortletWindowId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PortalRequestInfoImpl other = (PortalRequestInfoImpl)obj;
        if (this.targetedLayoutNodeId == null ? other.targetedLayoutNodeId != null : !this.targetedLayoutNodeId.equals(other.targetedLayoutNodeId)) {
            return false;
        }
        return !(this.targetedPortletWindowId == null ? other.targetedPortletWindowId != null : !this.targetedPortletWindowId.equals(other.targetedPortletWindowId));
    }

    public String toString() {
        return "PortalRequestInfoImpl [targetedLayoutNodeId=" + this.targetedLayoutNodeId + ", targetedPortletWindowId=" + this.targetedPortletWindowId + ", urlState=" + this.urlState + ", urlType=" + this.urlType + ", portalParameters=" + this.portalParameters + "]";
    }
}

