/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.url;

import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jasig.portal.url.IPortalRequestUtils;
import org.jasig.portal.url.PortalHttpServletRequestWrapperImpl;
import org.jasig.portal.utils.web.PortletHttpServletRequestWrapper;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.portlet.context.PortletRequestAttributes;

@Service(value="portalRequestUtils")
public class PortalRequestUtilsImpl
implements IPortalRequestUtils {
    public HttpServletRequest getPortletHttpRequest(PortletRequest portletRequest) {
        HttpServletRequest portalRequest = (HttpServletRequest)portletRequest.getAttribute(PortletHttpServletRequestWrapper.ATTRIBUTE__HTTP_SERVLET_REQUEST);
        if (portalRequest != null) {
            return portalRequest;
        }
        throw new IllegalArgumentException("The orginal portlet HttpServletRequest is not available from the PortletRequest using attribute '" + PortletHttpServletRequestWrapper.ATTRIBUTE__HTTP_SERVLET_REQUEST + "'");
    }

    public HttpServletRequest getOriginalPortalRequest(HttpServletRequest portletRequest) {
        HttpServletRequest portalRequest = (HttpServletRequest)portletRequest.getAttribute(PortalHttpServletRequestWrapperImpl.ATTRIBUTE__HTTP_SERVLET_REQUEST);
        if (portalRequest != null) {
            return portalRequest;
        }
        return portletRequest;
    }

    public HttpServletRequest getOriginalPortletOrPortalRequest(HttpServletRequest request) {
        HttpServletRequest portletRequest = (HttpServletRequest)request.getAttribute(PortletHttpServletRequestWrapper.ATTRIBUTE__HTTP_SERVLET_REQUEST);
        if (portletRequest != null) {
            return portletRequest;
        }
        return this.getOriginalPortalRequest(request);
    }

    public HttpServletRequest getOriginalPortalRequest(WebRequest request) {
        NativeWebRequest nativeWebRequest;
        Object nativeRequest;
        HttpServletRequest portalRequest = (HttpServletRequest)request.getAttribute(PortalHttpServletRequestWrapperImpl.ATTRIBUTE__HTTP_SERVLET_REQUEST, 0);
        if (portalRequest != null) {
            return portalRequest;
        }
        if (request instanceof NativeWebRequest && (nativeRequest = (nativeWebRequest = (NativeWebRequest)request).getNativeRequest()) instanceof HttpServletRequest) {
            return (HttpServletRequest)nativeRequest;
        }
        throw new IllegalArgumentException("The orginal portal HttpServletRequest is not available from the WebRequest using attribute '" + PortalHttpServletRequestWrapperImpl.ATTRIBUTE__HTTP_SERVLET_REQUEST + "'");
    }

    public HttpServletResponse getOriginalPortalResponse(PortletRequest portletRequest) {
        HttpServletResponse portalResponse = (HttpServletResponse)portletRequest.getAttribute(PortalHttpServletRequestWrapperImpl.ATTRIBUTE__HTTP_SERVLET_RESPONSE);
        if (portalResponse != null) {
            return portalResponse;
        }
        throw new IllegalArgumentException("The orginal portal HttpServletResponse is not available from the PortletRequest using attribute '" + PortalHttpServletRequestWrapperImpl.ATTRIBUTE__HTTP_SERVLET_RESPONSE + "'");
    }

    public HttpServletResponse getOriginalPortalResponse(HttpServletRequest portletRequest) {
        HttpServletResponse portalResponse = (HttpServletResponse)portletRequest.getAttribute(PortalHttpServletRequestWrapperImpl.ATTRIBUTE__HTTP_SERVLET_RESPONSE);
        if (portalResponse != null) {
            return portalResponse;
        }
        throw new IllegalArgumentException("The orginal portal HttpServletResponse is not available from the HttpServletRequest using attribute '" + PortalHttpServletRequestWrapperImpl.ATTRIBUTE__HTTP_SERVLET_RESPONSE + "'");
    }

    public HttpServletRequest getCurrentPortalRequest() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (requestAttributes instanceof ServletRequestAttributes) {
            HttpServletRequest request = ((ServletRequestAttributes)requestAttributes).getRequest();
            try {
                return this.getOriginalPortalRequest(request);
            }
            catch (IllegalArgumentException iae) {
                return request;
            }
        }
        if (requestAttributes instanceof PortletRequestAttributes) {
            PortletRequest request = ((PortletRequestAttributes)requestAttributes).getRequest();
            return this.getPortletHttpRequest(request);
        }
        throw new IllegalStateException("No ServletRequestAttributes or PortletRequestAttributes available from the RequestContextHolder. " + (requestAttributes == null ? null : requestAttributes.getClass().getName()));
    }
}

