/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.url;

import java.util.Map;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import javax.servlet.http.HttpServletRequest;
import org.jasig.portal.IUserPreferencesManager;
import org.jasig.portal.api.portlet.DelegationRequest;
import org.jasig.portal.layout.IUserLayoutManager;
import org.jasig.portal.layout.node.IUserLayoutNodeDescription;
import org.jasig.portal.portlet.delegation.IPortletDelegationManager;
import org.jasig.portal.portlet.om.IPortletEntity;
import org.jasig.portal.portlet.om.IPortletWindow;
import org.jasig.portal.portlet.om.IPortletWindowId;
import org.jasig.portal.portlet.registry.IPortletWindowRegistry;
import org.jasig.portal.url.IPortalActionUrlBuilder;
import org.jasig.portal.url.IPortalUrlBuilder;
import org.jasig.portal.url.IPortalUrlProvider;
import org.jasig.portal.url.IPortletUrlBuilder;
import org.jasig.portal.url.IUrlNodeSyntaxHelper;
import org.jasig.portal.url.IUrlNodeSyntaxHelperRegistry;
import org.jasig.portal.url.IUrlSyntaxProvider;
import org.jasig.portal.url.PortalUrlBuilder;
import org.jasig.portal.url.UrlType;
import org.jasig.portal.user.IUserInstance;
import org.jasig.portal.user.IUserInstanceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PortalUrlProviderImpl
implements IPortalUrlProvider {
    private static final String PORTAL_ACTION_URL_BUILDER = PortalUrlProviderImpl.class.getName() + ".PORTAL_ACTION_URL_BUILDER";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private IUrlSyntaxProvider urlSyntaxProvider;
    private IUserInstanceManager userInstanceManager;
    private IUrlNodeSyntaxHelperRegistry urlNodeSyntaxHelperRegistry;
    private IPortletWindowRegistry portletWindowRegistry;
    private IPortletDelegationManager portletDelegationManager;

    @Autowired
    public void setPortletDelegationManager(IPortletDelegationManager portletDelegationManager) {
        this.portletDelegationManager = portletDelegationManager;
    }

    @Autowired
    public void setUrlSyntaxProvider(IUrlSyntaxProvider urlSyntaxProvider) {
        this.urlSyntaxProvider = urlSyntaxProvider;
    }

    @Autowired
    public void setUserInstanceManager(IUserInstanceManager userInstanceManager) {
        this.userInstanceManager = userInstanceManager;
    }

    @Autowired
    public void setUrlNodeSyntaxHelperRegistry(IUrlNodeSyntaxHelperRegistry urlNodeSyntaxHelperRegistry) {
        this.urlNodeSyntaxHelperRegistry = urlNodeSyntaxHelperRegistry;
    }

    @Autowired
    public void setPortletWindowRegistry(IPortletWindowRegistry portletWindowRegistry) {
        this.portletWindowRegistry = portletWindowRegistry;
    }

    public IPortalActionUrlBuilder getPortalActionUrlBuilder(HttpServletRequest request) {
        return (IPortalActionUrlBuilder)request.getAttribute(PORTAL_ACTION_URL_BUILDER);
    }

    public IPortalActionUrlBuilder convertToPortalActionUrlBuilder(HttpServletRequest request, IPortalUrlBuilder portalUrlBuilder) {
        request.setAttribute(PORTAL_ACTION_URL_BUILDER, (Object)portalUrlBuilder);
        return (IPortalActionUrlBuilder)portalUrlBuilder;
    }

    public IPortalUrlBuilder getDefaultUrl(HttpServletRequest request) {
        IUrlNodeSyntaxHelper urlNodeSyntaxHelper = this.urlNodeSyntaxHelperRegistry.getCurrentUrlNodeSyntaxHelper(request);
        String defaultLayoutNodeId = urlNodeSyntaxHelper.getDefaultLayoutNodeId(request);
        return this.getPortalUrlBuilderByLayoutNode(request, defaultLayoutNodeId, UrlType.RENDER);
    }

    public IPortalUrlBuilder getPortalUrlBuilderByLayoutNode(HttpServletRequest request, String layoutNodeId, UrlType urlType) {
        IPortletWindowId portletWindowId = this.getPortletWindowId(request, layoutNodeId);
        return new PortalUrlBuilder(this.urlSyntaxProvider, request, layoutNodeId, portletWindowId, urlType);
    }

    private IPortletWindowId getPortletWindowId(HttpServletRequest request, String layoutNodeId) {
        if (layoutNodeId == null) {
            return null;
        }
        IUserLayoutNodeDescription.LayoutNodeType layoutNodeType = this.getLayoutNodeType(request, layoutNodeId);
        if (layoutNodeType == null) {
            throw new IllegalArgumentException("No layout node exists for id: " + layoutNodeId);
        }
        if (layoutNodeType != IUserLayoutNodeDescription.LayoutNodeType.PORTLET) {
            return null;
        }
        IPortletWindow portletWindow = this.portletWindowRegistry.getOrCreateDefaultPortletWindowByLayoutNodeId(request, layoutNodeId);
        if (portletWindow == null) {
            return null;
        }
        return portletWindow.getPortletWindowId();
    }

    public IPortalUrlBuilder getPortalUrlBuilderByPortletWindow(HttpServletRequest request, IPortletWindowId portletWindowId, UrlType urlType) {
        IPortletWindow portletWindow = this.portletWindowRegistry.getPortletWindow(request, portletWindowId);
        return this.getPortalUrlBuilderByPortletWindow(request, portletWindow, urlType);
    }

    public IPortalUrlBuilder getPortalUrlBuilderByPortletFName(HttpServletRequest request, String portletFName, UrlType urlType) {
        IPortletWindow portletWindow = this.portletWindowRegistry.getOrCreateDefaultPortletWindowByFname(request, portletFName);
        if (portletWindow == null) {
            throw new IllegalArgumentException("Could not find PortletWindow for fname=" + portletFName + " to create IPortalUrlBuilder");
        }
        return this.getPortalUrlBuilderByPortletWindow(request, portletWindow, urlType);
    }

    protected IPortalUrlBuilder getPortalUrlBuilderByPortletWindow(HttpServletRequest request, IPortletWindow portletWindow, UrlType urlType) {
        IPortletWindowId portletWindowId = portletWindow.getPortletWindowId();
        IPortletWindowId parentPortletWindowId = portletWindow.getDelegationParentId();
        if (parentPortletWindowId != null) {
            IPortalUrlBuilder portalUrlBuilder = this.getPortalUrlBuilderByPortletWindow(request, parentPortletWindowId, urlType);
            DelegationRequest delegationRequest = this.portletDelegationManager.getDelegationRequest(request, portletWindowId);
            if (delegationRequest != null) {
                WindowState parentWindowState;
                PortletMode parentPortletMode;
                IPortletUrlBuilder parentPortletUrlBuilder = portalUrlBuilder.getPortletUrlBuilder(parentPortletWindowId);
                Map parentParameters = delegationRequest.getParentParameters();
                if (parentParameters != null) {
                    parentPortletUrlBuilder.setParameters(parentParameters);
                }
                if ((parentPortletMode = delegationRequest.getParentPortletMode()) != null) {
                    parentPortletUrlBuilder.setPortletMode(parentPortletMode);
                }
                if ((parentWindowState = delegationRequest.getParentWindowState()) != null) {
                    parentPortletUrlBuilder.setWindowState(parentWindowState);
                }
            }
            return portalUrlBuilder;
        }
        String layoutNodeId = this.verifyPortletWindowId(request, portletWindowId);
        return new PortalUrlBuilder(this.urlSyntaxProvider, request, layoutNodeId, portletWindowId, urlType);
    }

    protected String verifyPortletWindowId(HttpServletRequest request, IPortletWindowId portletWindowId) {
        IUserInstance userInstance = this.userInstanceManager.getUserInstance(request);
        IUserPreferencesManager preferencesManager = userInstance.getPreferencesManager();
        IUserLayoutManager userLayoutManager = preferencesManager.getUserLayoutManager();
        IPortletWindow portletWindow = this.portletWindowRegistry.getPortletWindow(request, portletWindowId);
        IPortletWindowId delegationParentWindowId = portletWindow.getDelegationParentId();
        if (delegationParentWindowId != null) {
            return this.verifyPortletWindowId(request, delegationParentWindowId);
        }
        IPortletEntity portletEntity = portletWindow.getPortletEntity();
        String channelSubscribeId = portletEntity.getLayoutNodeId();
        IUserLayoutNodeDescription node = userLayoutManager.getNode(channelSubscribeId);
        if (node == null) {
            throw new IllegalArgumentException("No layout node exists for id " + channelSubscribeId + " of window " + portletWindowId);
        }
        return node.getId();
    }

    protected IUserLayoutNodeDescription.LayoutNodeType getLayoutNodeType(HttpServletRequest request, String folderNodeId) {
        IUserInstance userInstance = this.userInstanceManager.getUserInstance(request);
        IUserPreferencesManager preferencesManager = userInstance.getPreferencesManager();
        IUserLayoutManager userLayoutManager = preferencesManager.getUserLayoutManager();
        IUserLayoutNodeDescription node = userLayoutManager.getNode(folderNodeId);
        if (node == null) {
            return null;
        }
        return node.getType();
    }
}

