/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.url;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.math.NumberUtils;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.security.IPersonManager;
import org.jasig.portal.url.IPortalRequestInfo;
import org.jasig.portal.url.IUrlSyntaxProvider;
import org.jasig.portal.url.LoginRefUrlEncoder;
import org.jasig.portal.url.PortalHttpServletRequestWrapper;
import org.jasig.portal.url.PortalHttpServletRequestWrapperImpl;
import org.jasig.portal.url.PortalHttpServletResponseWrapper;
import org.jasig.portal.url.UrlState;
import org.jasig.portal.url.UrlType;
import org.jasig.portal.user.IUserInstanceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.filter.OncePerRequestFilter;

public class UrlCanonicalizingFilter
extends OncePerRequestFilter {
    private static final String COOKIE_NAME = "UrlCanonicalizingFilter.REDIRECT_COUNT";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private IUrlSyntaxProvider urlSyntaxProvider;
    private IPersonManager personManager;
    private IUserInstanceManager userInstanceManager;
    private int maximumRedirects = 5;
    private LoginRefUrlEncoder loginRefUrlEncoder;

    @Autowired
    public void setUrlSyntaxProvider(IUrlSyntaxProvider urlSyntaxProvider) {
        this.urlSyntaxProvider = urlSyntaxProvider;
    }

    @Autowired
    public void setPersonManager(IPersonManager personManager) {
        this.personManager = personManager;
    }

    @Autowired
    public void setUserInstanceManager(IUserInstanceManager userInstanceManager) {
        this.userInstanceManager = userInstanceManager;
    }

    @Autowired(required=false)
    public void setLoginRefUrlEncoder(LoginRefUrlEncoder loginRefUrlEncoder) {
        this.loginRefUrlEncoder = loginRefUrlEncoder;
    }

    public void setMaximumRedirects(int maximumRedirects) {
        this.maximumRedirects = maximumRedirects;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if ("GET".equals(request.getMethod())) {
            String canonicalUrl = this.urlSyntaxProvider.getCanonicalUrl(request);
            int queryStringIndex = canonicalUrl.indexOf("?");
            String canonicalUri = queryStringIndex < 0 ? canonicalUrl : canonicalUrl.substring(0, queryStringIndex);
            String requestURI = request.getRequestURI();
            int redirectCount = this.getRedirectCount(request);
            if (!canonicalUri.equals(requestURI)) {
                if (redirectCount < this.maximumRedirects) {
                    this.setRedirectCount(request, response, redirectCount + 1);
                    String encodedTargetUrl = null;
                    IPerson person = this.personManager.getPerson(request);
                    if (person.isGuest() && this.urlSyntaxProvider.doesRequestPathReferToSpecificAndDifferentContentVsCanonicalPath(requestURI, canonicalUri) && this.loginRefUrlEncoder != null) {
                        encodedTargetUrl = this.loginRefUrlEncoder.encodeLoginAndRefUrl(request);
                    }
                    if (encodedTargetUrl == null) {
                        encodedTargetUrl = response.encodeRedirectURL(canonicalUrl);
                    }
                    response.sendRedirect(encodedTargetUrl);
                    this.logger.debug("Redirecting from {} to canonicalized URL {}, redirect {}", new Object[]{requestURI, canonicalUri, redirectCount});
                    return;
                }
                this.clearRedirectCount(request, response);
                this.logger.debug("Not redirecting from {} to canonicalized URL {} due to limit of {} redirects", new Object[]{requestURI, canonicalUri, redirectCount});
            } else if (redirectCount > 0) {
                this.clearRedirectCount(request, response);
            }
        }
        IPortalRequestInfo portalRequestInfo = this.urlSyntaxProvider.getPortalRequestInfo(request);
        UrlType urlType = portalRequestInfo.getUrlType();
        UrlState urlState = portalRequestInfo.getUrlState();
        PortalHttpServletResponseWrapper httpServletResponseWrapper = new PortalHttpServletResponseWrapper(response);
        PortalHttpServletRequestWrapper httpServletRequestWrapper = PortalHttpServletRequestWrapperImpl.create((HttpServletRequest)request, (HttpServletResponse)httpServletResponseWrapper, (IUserInstanceManager)this.userInstanceManager);
        httpServletRequestWrapper.setHeader(IPortalRequestInfo.URL_TYPE_HEADER, urlType.toString());
        httpServletRequestWrapper.setHeader(IPortalRequestInfo.URL_STATE_HEADER, urlState.toString());
        httpServletRequestWrapper.setHeader(IPortalRequestInfo.URL_TYPE_HEADER + "." + urlType, Boolean.TRUE.toString());
        httpServletRequestWrapper.setHeader(IPortalRequestInfo.URL_STATE_HEADER + "." + urlState, Boolean.TRUE.toString());
        filterChain.doFilter((ServletRequest)httpServletRequestWrapper, (ServletResponse)httpServletResponseWrapper);
    }

    protected void clearRedirectCount(HttpServletRequest request, HttpServletResponse response) {
        Cookie cookie = new Cookie(COOKIE_NAME, "");
        cookie.setPath(request.getContextPath());
        cookie.setMaxAge(0);
        response.addCookie(cookie);
    }

    protected void setRedirectCount(HttpServletRequest request, HttpServletResponse response, int count) {
        Cookie cookie = new Cookie(COOKIE_NAME, Integer.toString(count));
        cookie.setPath(request.getContextPath());
        cookie.setMaxAge(30);
        response.addCookie(cookie);
    }

    protected int getRedirectCount(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return 0;
        }
        for (Cookie cookie : cookies) {
            if (!COOKIE_NAME.equals(cookie.getName())) continue;
            String value = cookie.getValue();
            return NumberUtils.toInt((String)value, (int)0);
        }
        return 0;
    }
}

